<?php 
	use App\Models\Location; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Masters</li>
					<li class="active">Locations</li>
					<li class="active">City</li>
					<li class="active">Add</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add City</h1>
					</div><!--end .col -->
					
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/masters/locations/city","Manage City List",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/masters/locations/city/add","class"=>"form"]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Add City</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
										<div class="form-group @if($errors->has('country'))has-error @endif">
											{!! Form::select("country",[""=>"Select Country"]+$countries,"",["class"=>"form-control","id"=>"country"]) !!}
												@if($errors->has("country"))
													<span id="country-error" class="help-block">{!! $errors->first("country") !!}</span>
												@endif
											{!! HTML::decode(Form::label("country","Country<span class='text-danger'>*</span>")) !!}
										</div>
										<div class="form-group @if($errors->has('state'))has-error @endif">
											{!! Form::select("state",[""=>"Select State"],"",["class"=>"form-control","id"=>"state"]) !!}
												@if($errors->has("state"))
													<span id="state-error" class="help-block">{!! $errors->first("state") !!}</span>
												@endif
											{!! HTML::decode(Form::label("state","State<span class='text-danger'>*</span>")) !!}
										</div>
										<div class="form-group @if($errors->has('cityName'))has-error @endif">
											{!! Form::text("cityName","",["class"=>"form-control"]) !!}
												@if($errors->has("cityName"))
													<span id="cityName-error" class="help-block">{!! $errors->first("cityName") !!}</span>
												@endif
											{!! HTML::decode(Form::label("cityName","City Name<span class='text-danger'>*</span>")) !!}
										</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add City</button>
									</div>
								</div>
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/js/bala.js')!!}
@stop