<?php 
	use App\Models\Location; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Masters</li>
					<li class="active">Locations</li>
					<li class="active">Country</li>
					<li class="active">Add</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add Country</h1>
					</div><!--end .col -->
					
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/masters/locations/country","Manage Country",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/masters/locations/country/add","class"=>"form"]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Add Country</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
											<div class="form-group @if($errors->has('countryName'))has-error @endif">
												{!! Form::text("countryName","",["class"=>"form-control"]) !!}
													@if($errors->has("countryName"))
														<span id="countryName-error" class="help-block">{!! $errors->first("countryName") !!}</span>
													@endif
												{!! HTML::decode(Form::label("countryName","Country Name<span class='text-danger'>*</span>")) !!}
											</div>
											

											<div class="form-group @if($errors->has('countryCode'))has-error @endif">
												{!! Form::text("countryCode","",["class"=>"form-control"]) !!}
													@if($errors->has("countryCode"))
														<span id="countryCode-error" class="help-block">{!! $errors->first("countryCode") !!}</span>
													@endif
												{!! HTML::decode(Form::label("countryCode","Country Code<span class='text-danger'>*</span>")) !!}
											</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add Country</button>
									</div>
								</div>
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/js/bala.js')!!}
{!!HTML::script('backend/assets/js/libs/jquery-validation/dist/jquery.validate.min.js')!!}
{!!HTML::script('backend/assets/js/libs/jquery-validation/dist/additional-methods.min.js')!!}
@stop