<?php 
	use App\Models\Productdetails; 
?>
@extends("backend/master")
@section('maincontent')

<style type="text/css">
	.hidecouponDiv{
		display: none;
	}
</style>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Coupon</li>
					<li class="active">Add New Coupon Code</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add New Coupon Code</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/coupon","Manage Coupon Codes",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/coupon/add","class"=>"form"]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Create Coupon Code</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									<?php
			            				$products = Productdetails::lists("productname", "id")->toArray();
			            			?>
			            			<div class="form-group @if($errors->has('products'))has-error @endif">
									{!! Form::select("products",$products,"",["class"=>"form-control","id"=>"products",'placeholder'=>'Select Product']) !!}
											@if($errors->has("products"))
												<span id="products-error" class="help-block">{!! $errors->first("products") !!}</span>
											@endif
											{!! Form::label("products","Select Product") !!}
									</div>

									<div class="form-group @if($errors->has('couponName'))has-error @endif">
									{!! Form::text("couponName","",["class"=>"form-control",'id'=>'couponName']) !!}
											@if($errors->has("couponName"))
												<span id="couponName-error" class="help-block">{!! $errors->first("couponName") !!}</span>
											@endif
											{!! HTML::decode(Form::label("couponName","Coupon Name<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('couponCode'))has-error @endif">
									{!! Form::text("couponCode","",["class"=>"form-control",'id'=>'couponCode']) !!}
											@if($errors->has("couponCode"))
												<span id="couponCode-error" class="help-block">{!! $errors->first("couponCode") !!}</span>
											@endif
											{!! HTML::decode(Form::label("couponCode","Coupon Code<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('couponType'))has-error @endif">
									{!! Form::select("couponType",[""=>"Select Type",'percentage'=>'Percentage','fixed'=>"Fixed Amount"],"",["class"=>"form-control","id"=>"couponType"]) !!}
											@if($errors->has("couponType"))
												<span id="couponType-error" class="help-block">{!! $errors->first("couponType") !!}</span>
											@endif
											{!! Form::label("couponType","Coupon Type") !!}
									</div>

									<div class="form-group hidecouponDiv @if($errors->has('percentage'))has-error @endif" id="percentageDiv">
									{!! Form::text("percentage","",["class"=>"form-control"]) !!}
											@if($errors->has("percentage"))
												<span id="percentage-error" class="help-block">{!! $errors->first("percentage") !!}</span>
											@endif
											{!! Form::label("percentage","Percentage") !!}
									</div>


									<div class="form-group hidecouponDiv @if($errors->has('totalAmount'))has-error @endif" id="totalAmountDiv">
									{!! Form::text("totalAmount","",["class"=>"form-control"]) !!}
											@if($errors->has("totalAmount"))
												<span id="totalAmount-error" class="help-block">{!! $errors->first("totalAmount") !!}</span>
											@endif
											{!! Form::label("totalAmount","Total Amount") !!}
									</div>

									<div class="form-group @if($errors->has('startDate'))has-error @endif">
									{!! Form::text("startDate","",["class"=>"form-control",'id'=>'startDate']) !!}
											@if($errors->has("startDate"))
												<span id="startDate-error" class="help-block">{!! $errors->first("startDate") !!}</span>
											@endif
											{!! Form::label("startDate","Date Start") !!}
									</div>


									<div class="form-group @if($errors->has('endDate'))has-error @endif">
									{!! Form::text("endDate","",["class"=>"form-control",'id'=>'endDate']) !!}
											@if($errors->has("endDate"))
												<span id="endDate-error" class="help-block">{!! $errors->first("endDate") !!}</span>
											@endif
											{!! Form::label("endDate","Date End") !!}
									</div>

									<div class="form-group @if($errors->has('totalCoupon'))has-error @endif">
									{!! Form::text("totalCoupon","1",["class"=>"form-control"]) !!}
											@if($errors->has("totalCoupon"))
												<span id="usesPerCoupon-error" class="help-block">{!! $errors->first("totalCoupon") !!}</span>
											@endif
											{!! Form::label("totalCoupon","Total Coupon") !!}
									</div>


									<div class="form-group @if($errors->has('usesPerCustomers'))has-error @endif">
									{!! Form::text("usesPerCustomers","1",["class"=>"form-control"]) !!}
											@if($errors->has("usesPerCustomers"))
												<span id="usesPerCustomers-error" class="help-block">{!! $errors->first("usesPerCustomers") !!}</span>
											@endif
											{!! Form::label("usesPerCustomers","Uses Per Customers") !!}
									</div>

									<div class="form-group @if($errors->has('status'))has-error @endif">
									{!! Form::select("status",['active'=>'Active','inactive'=>"Inactive",'deleted'=>'Deleted'],"active",["class"=>"form-control","id"=>"status"]) !!}
											@if($errors->has("status"))
												<span id="status-error" class="help-block">{!! $errors->first("status") !!}</span>
											@endif
											{!! Form::label("status","Status") !!}
									</div>

								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add Coupon Code</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/assets/js/libs/bootstrap-datepicker/bootstrap-datepicker.js')!!}
<script type="text/javascript">
	
 $( "#startDate" ).datepicker({
      defaultDate: "+1w",
      changeMonth: true,
      numberOfMonths: 3,
      onClose: function( selectedDate ) {
        $( "#endDate" ).datepicker( "option", "minDate", selectedDate );
      }
    });
    $( "#endDate" ).datepicker({
      defaultDate: "+1w",
      changeMonth: true,
      numberOfMonths: 3,
      onClose: function( selectedDate ) {
        $( "#startDate" ).datepicker( "option", "maxDate", selectedDate );
      }
    });

    $('#category').select2({
  placeholder: "Select a Category"
});

showcoubondiv();

$('#couponType').on('change', function(){
	showcoubondiv();
});
function showcoubondiv(){
	$('.hidecouponDiv').hide();
	var type = $('#couponType').val();
	if(type == 'percentage'){
		$('#percentageDiv').show();
	}
	if(type == 'fixed'){
		$('#totalAmountDiv').show();
	}
	return false;
}


$('#products').select2({
  placeholder: "Select a Products"
});

$('#couponName').on('keyup', function(){
	var v = $(this).val();
	var slug = convertToSlug(v);
	$('#couponCode').val(slug);
});


function convertToSlug(Text){
    return Text
        .toUpperCase()
        .replace(/ /g,'')
        .replace(/[^\w-]+/g,'')
        ;
}

</script>
@stop