<?php 
	use App\Models\Location; 
?>
@extends("backend/master")
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css')!!}
@stop
@section('maincontent')


	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Locations</li>
					<li class="active">City</li>
				</ol>
			</div>
			<div class="section-header">
				<h2 class="text-primary">City List</h2>
			</div>
			<div class="section-header pull-right">
				{!! HTML::link("admin/masters/locations/city/add","Add City",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
			</div>
			<div class="section-body">
				<!-- BEGIN DATATABLE 1 -->
				<div class="row">
					<div class="col-md-8">
						<article class="margin-bottom-xxl">
							<p class="lead">
								DataTables is a plug-in for the jQuery Javascript library.
								It is a highly flexible tool, based upon the foundations of progressive enhancement, and will add advanced interaction controls to any HTML table.
							</p>
						</article>
					</div><!--end .col -->
				</div><!--end .row -->
				<div class="row">
				<div class="col-md-4">
					{!! Form::open(["url"=>"admin/masters/locations/state/post","class"=>"form"]) !!}
						<div class="card">
							@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
							<div class="card-body">
								<div class="form-group @if($errors->has('country'))has-error @endif">
									{!! Form::select("country",[""=>"Select Country"]+$countries,"",["class"=>"form-control","id"=>"country"]) !!}
										@if($errors->has("country"))
											<span id="country-error" class="help-block">{!! $errors->first("country") !!}</span>
										@endif
									{!! HTML::decode(Form::label("country","Country<span class='text-danger'>*</span>")) !!}
								</div>
								<div class="form-group @if($errors->has('state'))has-error @endif">
									{!! Form::select("state",[""=>"Select State"],"",["class"=>"form-control","id"=>"state"]) !!}
										@if($errors->has("state"))
											<span id="state-error" class="help-block">{!! $errors->first("state") !!}</span>
										@endif
									{!! HTML::decode(Form::label("state","State<span class='text-danger'>*</span>")) !!}
								</div>
							</div><!--end .card-body -->
						</div><!--end .card -->
					{!! Form::close() !!}
				</div><!--end .col -->
				</div><!--end .row -->
				<div class="row">
					<div class="col-md-12">
						<h4></h4>
					</div><!--end .col -->
					<div class="col-lg-12" id="cityDiv" style="display:none;">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Name</th>
										<th class="sort-numeric">Status</th>
										<th class="sort-alpha">Actions</th>
									</tr>
								</thead>
								<tbody>
									
									
									
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!!HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js')!!}
	{!!HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js')!!}
	{!!HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js')!!}
	{!!HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js')!!}
	{!!HTML::script('backend/js/bala.js')!!}
	<script type="text/javascript">
	$(document).ready(function(){
    	$('#myTable').DataTable();
	});
	</script>
@stop