<?php 
	use App\Models\Location; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Masters</li>
					<li class="active">Locations</li>
					<li class="active">State</li>
					<li class="active">Modify</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Modify State</h1>
					</div><!--end .col -->
					
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/masters/locations/state","Manage State List",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-8">
						{!! Form::open(["url"=>"admin/masters/locations/state/modify/".$state->id,"class"=>"form"]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Modify State</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
											<div class="form-group @if($errors->has('countryName'))has-error @endif">
												{!! Form::select("countryName",[""=>"Select Country"]+$countries,$state->parentId,["class"=>"form-control"]) !!}
													@if($errors->has("countryName"))
														<span id="countryName-error" class="help-block">{!! $errors->first("countryName") !!}</span>
													@endif
												{!! HTML::decode(Form::label("countryName","Select Country<span class='text-danger'>*</span>")) !!}
											</div>

											<div class="form-group @if($errors->has('stateName'))has-error @endif">
												{!! Form::text("stateName",$state->name,["class"=>"form-control"]) !!}
													@if($errors->has("stateName"))
														<span id="stateName-error" class="help-block">{!! $errors->first("stateName") !!}</span>
													@endif
												{!! HTML::decode(Form::label("stateName","State Name<span class='text-danger'>*</span>")) !!}
											</div>
											

											<div class="form-group @if($errors->has('stateCode'))has-error @endif">
												{!! Form::text("stateCode",$state->code,["class"=>"form-control"]) !!}
													@if($errors->has("stateCode"))
														<span id="stateCode-error" class="help-block">{!! $errors->first("stateCode") !!}</span>
													@endif
												{!! HTML::decode(Form::label("stateCode","State Code<span class='text-danger'>*</span>")) !!}
											</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Modify State</button>
									</div>
								</div>
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/js/bala.js')!!}
{!!HTML::script('backend/assets/js/libs/jquery-validation/dist/jquery.validate.min.js')!!}
{!!HTML::script('backend/assets/js/libs/jquery-validation/dist/additional-methods.min.js')!!}
@stop