<?php 
	use App\Models\Location; 
?>
@extends("backend/master")
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css')!!}
@stop
@section('maincontent')


	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Locations</li>
					<li class="active">States</li>
				</ol>
			</div>
			<div class="section-header">
				<h2 class="text-primary">State List</h2>
			</div>
			<div class="section-header pull-right">
				{!! HTML::link("admin/masters/locations/state/add","Add State",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
			</div>
			<div class="section-body">
				<!-- BEGIN DATATABLE 1 -->
				<div class="row">
					<div class="col-md-8">
						<article class="margin-bottom-xxl">
							<p class="lead">
								DataTables is a plug-in for the jQuery Javascript library.
								It is a highly flexible tool, based upon the foundations of progressive enhancement, and will add advanced interaction controls to any HTML table.
							</p>
						</article>
					</div><!--end .col -->
				</div><!--end .row -->
				<div class="row">
				<div class="col-md-4">
					{!! Form::open(["url"=>"admin/masters/locations/state/post","class"=>"form"]) !!}
						<div class="card">
							@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
							<div class="card-body">
								<div class="form-group @if($errors->has('countryName'))has-error @endif">
									{!! Form::select("countryName",[""=>"Select Country"]+$countries,"",["class"=>"form-control","id"=>"countryName"]) !!}
									{!! HTML::decode(Form::label("countryName","Select Country<span class='text-danger'>*</span>")) !!}
								</div>
								@if($errors->has("countryName"))
									<span class="text-danger">{!! $errors->first("countryName") !!}</span>
								@endif
							</div><!--end .card-body -->
						</div><!--end .card -->
					{!! Form::close() !!}
				</div><!--end .col -->
				</div><!--end .row -->
				<div class="row">
					<div class="col-md-12">
						<h4>Manage States</h4>
					</div><!--end .col -->
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Name</th>
										<th>Code</th>
										<th class="sort-numeric">Status</th>
										<th class="sort-alpha">Actions</th>
									</tr>
								</thead>
								<tbody>
									
									
									
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!!HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js')!!}
	{!!HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js')!!}
	{!!HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js')!!}
	{!!HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js')!!}
	{!!HTML::script('backend/js/bala.js')!!}
	<script type="text/javascript">
	$(document).ready(function(){
    	
	});
	</script>
@stop