<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>
@extends("backend/master")

@section('styles')
	{!! HTML::style('backend/assets/css/jquery-ui.css') !!}
@stop

@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content" ng-app="individualMembersFilter" ng-controller="individualMembersController">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li>Individual Members</li>
				</ol>
			</div>

			<div id="exclUploadDiv">
		      	<div class="card">
		        	<div class="card-body">
		          		<div class="row">
		            		{!! Form::open(["id"=>"individualMembersSearchForm"]) !!}
		            			<div class="col-lg-3">
		              				{!! Form::text("dateFrom","",["class"=>"form-control","id"=>"dateFrom","placeholder"=>"From Date","ng-model"=>"params.dateFrom"]) !!}
					              	@if($errors->has("dateFrom"))
										<span id="dateFrom-error" class="help-block">{!! $errors->first("dateFrom") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				{!! Form::text("dateTo","",["class"=>"form-control","id"=>"dateTo","placeholder"=>"To Date","ng-model"=>"params.dateTo"]) !!}
					              	@if($errors->has("dateTo"))
										<span id="dateTo-error" class="help-block">{!! $errors->first("dateTo") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				{!! Form::text("membershipID","",["class"=>"form-control","id"=>"membershipID","placeholder"=>"Membership ID","ng-model"=>"params.membershipID"]) !!}
					              	@if($errors->has("membershipID"))
										<span id="membershipID-error" class="help-block">{!! $errors->first("membershipID") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				<select class="form-control" ng-model="params.membership" ng-options="me.id as me.name for me in membershipMaster" data-placeholder="Select Membership"></select>

					              	@if($errors->has("membership"))
										<span id="membership-error" class="help-block">{!! $errors->first("membership") !!}</span>
									@endif
		            			</div>

		            			<div class="clearfix"></div>	
		            			<br>
		            			
					            <div class="col-lg-2">
					                <input type="submit" class="btn ink-reaction pull-left btn-primary" ng-click="searchIndividualMembers($event)">
					            </div>
		            		{!! Form::close() !!}
		          		</div>
		        	</div>
		      	</div>
		  	</div>

		  	<div class="clearfix"></div>

  			@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

  			<div class="preLoadingDiv" style='display:none'>
		        <div class="spinner">
				  <div class="bounce1"></div>
				  <div class="bounce2"></div>
				  <div class="bounce3"></div>
				</div>
		        <p class="text-center">Processing.... Please wait...</p>
		    </div>

			<section id="individualMembersTable" style="display:none">
				<div class="section-header">
					<div class="row">
						<div class="col-lg-6">
							<h2 class="text-primary">Individual Members</h2>
						</div>
					</div>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="col-lg-12">
							<div class="table-responsive">
								<div style="float: left;"><b>Shows</b> &nbsp;&nbsp;
									<select ng-model="recordLimit"  ng-init="recordLimit=10" ng-options="item for item in recordArray">
									</select>
								</div>

								<div style="float: right;"><b>Search</b> &nbsp;&nbsp;<input type="text" ng-model="filterSearch"></div>

								<table id="myTable" class="table table-striped table-hover">
									<thead>
										<tr>
											<th ng-click="sort('sno')">#</th>
											<th ng-click="sort('unique_id')">Membership ID</th>
											<th ng-click="sort('mem_category')">Type</th>
											<th ng-click="sort('org_name')">Working Company</th>
											<th ng-click="sort('con_person')">Name</th>
											<th ng-click="sort('mobile')">Contact</th>
											<th ng-click="sort('email')">Email ID</th>
											<th ng-click="sort('status')">Status</th>
											<th ng-click="sort('unique_id')">Action</th>
										</tr>
									</thead>

									<tbody>
										<tr dir-paginate="rec in records |orderBy:sortKey:reverse | filter: filterSearch|itemsPerPage:recordLimit">

											<td>@{{ rec.sno }}</td>
											<td>@{{ rec.unique_id }}</td>
											<td>@{{ rec.mem_category|capitalize }}</td>
											<td>@{{ rec.con_person|uppercase }}</td>
											<td>@{{ rec.org_name|uppercase }}</td>
											<td>@{{ rec.mobile }}</td>
											<td>@{{ rec.email }}</td>
											<td><button type="button" class="btn ink-reaction btn-xs btn-@{{rec.status=='active'?'success':'danger'}} individualStatus" data-id="@{{rec.id}}">@{{rec.status=='active'?'Active':'Inactive'}}</button></td>
											<td><a href="{!! URL::to('admin/members/individual/modify/get') !!}/@{{ rec.id }}"><i class="fa fa-edit"></i></a></td>
										</tr>
									</tbody>
								</table>

								<dir-pagination-controls
							       max-size="10"
							       direction-links="true"
							       boundary-links="true" >
							    </dir-pagination-controls>
							</div><!--end .table-responsive -->
						</div><!--end .col -->
					</div><!--end .row -->
					<!-- END DATATABLE 1 -->
				</div><!--end .section-body -->
			</section>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/js/angular.min.js') !!}
  	{!! HTML::script('backend/js/dirPagination.js') !!}
  	{!! HTML::script('backend/assets/js/jquery-ui.js') !!}
  	{!! HTML::script('backend/js/angular-select2.min.js') !!}
  	{!! HTML::script('backend/js/bala.js') !!}
	<script>
		$(document).ready(function(){
	    	$("#dateFrom").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$("#dateTo").datepicker( "option", "minDate", selectedDate );
		      	}
		    });

		    $( "#dateTo" ).datepicker({
		      	dateFormat:'yy-mm-dd',
		      	changeMonth: false,
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$( "#dateFrom" ).datepicker( "option", "maxDate", selectedDate );
		      	}
		    });
		});

		var app = angular.module('individualMembersFilter',['angularUtils.directives.dirPagination', 'ui.select2']);
		app.controller('individualMembersController', function($timeout, $scope, $http){
			
			// $timeout(function(){
			// 	$scope.searchIndividualMembers();
			// }, 500);
			$scope.membershipMaster = [{id:'', name:'All'}, {id:'individual', name:'Individual'}, {id:'student', name:'Student'}];
			$scope.params = {};
	        $scope.params.dateFrom = '';
	        $scope.params.dateTo = '';
	        $scope.params.membershipID = '';
	        $scope.params.membership = '';
	      
			$scope.searchIndividualMembers = function(event) {
				event.preventDefault();
				angular.element(document.querySelector('#individualMembersTable')).hide();
				$('.preLoadingDiv').show();
				$('#courseAppliedTable').hide();
				$('#displayError').hide();
				$scope.records = [];
				$scope.recordArray = [10, 25, 50, 100];
				$http({
		          	method  : 'POST',
		          	url     : '/admin/members/individual/post',
		          	data    : $scope.params,
		        }).success(function(data){
		         	console.log(data);
		         	$scope.originaldata = data;
					$scope.datalength = $scope.originaldata.length;

					if($scope.datalength > 0){
						for(var i = 0; i < $scope.originaldata.length; i++){
							$scope.originaldata[i].sno = i + 1;
							$scope.records.push($scope.originaldata[i]);
						}
						angular.element(document.querySelector('.preLoadingDiv')).hide();
						angular.element(document.querySelector('#individualMembersTable')).show();
					}else{
						$('.preLoadingDiv').hide();
						angular.element(document.querySelector('#individualMembersTable')).hide();
		         		swal("Error!", "Error processing your request", "error");
		         		return false;
					}
				});
			}

			$scope.sort = function(keyname){
		        $scope.sortKey = keyname;   //set the sortKey to the param passed
		        $scope.reverse = !$scope.reverse; //if true make it false and vice versa
		    }
		});

		app.filter('capitalize', function() {
		    return function(input) {
		      return (!!input) ? input.charAt(0).toUpperCase() + input.substr(1).toLowerCase() : '';
		    }
		});

		app.filter('secondsToDateTime', function() {
		    return function(seconds) {
		        var d = new Date(0,0,0,0,0,0,0);
		        d.setSeconds(seconds);
		        return d;
		    };
		});
	</script>
@stop