<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>
@extends("backend/master")

@section('styles')
	{!! HTML::style('backend/assets/css/jquery-ui.css') !!}
@stop

@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content" ng-app="appliedMembersFilter" ng-controller="appliedMembersController">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li>Members Applied</li>
				</ol>
			</div>

			<div id="exclUploadDiv">
		      	<div class="card">
		        	<div class="card-body">
		          		<div class="row">
		            		{!! Form::open(["id"=>"appliedMembersSearchForm"]) !!}
		            			<div class="col-lg-3">
		              				{!! Form::text("dateFrom","",["class"=>"form-control","id"=>"dateFrom","placeholder"=>"From Date","ng-model"=>"params.dateFrom"]) !!}
					              	@if($errors->has("dateFrom"))
										<span id="dateFrom-error" class="help-block">{!! $errors->first("dateFrom") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				{!! Form::text("dateTo","",["class"=>"form-control","id"=>"dateTo","placeholder"=>"To Date","ng-model"=>"params.dateTo"]) !!}
					              	@if($errors->has("dateTo"))
										<span id="dateTo-error" class="help-block">{!! $errors->first("dateTo") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				{!! Form::text("membershipID","",["class"=>"form-control","id"=>"membershipID","placeholder"=>"Membership ID","ng-model"=>"params.membershipID"]) !!}
					              	@if($errors->has("membershipID"))
										<span id="membershipID-error" class="help-block">{!! $errors->first("membershipID") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				<select ui-select2 ng-model="params.membership" data-placeholder="Select Membership">
		              					<option value=""></option>
									    <option value="corporate">Corporate</option>
									    <option value="individual">Individual</option>
									    <option value="student">Student</option>
									</select>

					              	@if($errors->has("membership"))
										<span id="membership-error" class="help-block">{!! $errors->first("membership") !!}</span>
									@endif
		            			</div>

		            			<div class="clearfix"></div>	
		            			<br>
		            			
					            <div class="col-lg-2">
					                <input type="submit" class="btn ink-reaction pull-left btn-primary" ng-click="searchAppliedMembers($event)">
					            </div>
		            		{!! Form::close() !!}
		          		</div>
		        	</div>
		      	</div>
		  	</div>

		  	<div class="clearfix"></div>

  			@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

  			<div class="processLoadingDiv" style='display:none'>
		        <div class="spinner">
				  <div class="bounce1"></div>
				  <div class="bounce2"></div>
				  <div class="bounce3"></div>
				</div>
		        <p class="text-center">Processing.... Please wait...</p>
		    </div>

			<section id="appliedMembersTable" style="display:none">

				<div class="section-header">
					<div class="row">
						<div class="col-lg-6">
							<h2 class="text-primary">Members Applied</h2>
						</div>
					</div>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="col-lg-12">
							<div class="table-responsive">
								<div style="float: left;"><b>Shows</b> &nbsp;&nbsp;
									<select ng-model="recordLimit"  ng-init="recordLimit=10" ng-options="item for item in recordArray">
									</select>
								</div>

								<div style="float: right;"><b>Search</b> &nbsp;&nbsp;<input type="text" ng-model="filterSearch"></div>

								<table id="myTable" class="table table-striped table-hover">
									<thead>
										<tr>
											<th ng-click="sort('sno')">#</th>
											<th ng-click="sort('unique_id')">Memb. ID</th>
											<th ng-click="sort('mem_category')">Type</th>
											<th ng-click="sort('org_name')">Org. Name</th>
											<th ng-click="sort('con_person')">Contact Person</th>
											<th ng-click="sort('total_mem')">Members</th>
											<th ng-click="sort('date_registered')">DOR</th>
											<th ng-click="sort('price')">Amount (Rs.)</th>
											<th ng-click="sort('status')">Memb. Status</th>
											<th ng-click="sort('paymentStatus')">Payment Status</th>
											<th ng-click="sort('sno')">Actions</th>
										</tr>
									</thead>

									<tbody>
										<tr dir-paginate="rec in records |orderBy:sortKey:reverse | filter: filterSearch|itemsPerPage:recordLimit">
											<td>@{{ rec.sno }}</td>
											<td>@{{ rec.unique_id }}</td>
											<td>@{{ rec.mem_category|capitalize }}</td>
											<td>@{{ rec.org_name|capitalize }}</td>
											<td>@{{ rec.con_person|capitalize }}</td>
											<td>@{{ rec.total_mem > 0 ? rec.total_mem : 'NIL' }}</td>
											<td>@{{ rec.date_registered }}</td>
											<td>@{{ rec.price }}</td>
											<td>
												<div ng-if="rec.status == 'active'">
													<button type="button" class="btn ink-reaction btn-xs btn-success" ng-click="clickAppliedMemberStatus(rec, $index)">@{{ rec.status }}</button>
												</div>

												<div ng-if="rec.status == 'inactive'">
													<button type="button" class="btn ink-reaction btn-xs btn-danger" ng-click="clickAppliedMemberStatus(rec, $index)">@{{ rec.status }}</button>
												</div>
											</td>
											<td>
												<button type="button" class="btn ink-reaction btn-xs btn-success">@{{ rec.paymentStatus }}</button>
											</td>
											<td>
												<a href="{!! URL::to('admin/members/applied/modify/get') !!}/@{{ rec.id }}" target="_blank" type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit Member"><i class="fa fa-pencil"></i>
												</a>

												<button type="button" class="btn btn-icon-toggle userDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete Member" ng-click="clickAppliedMemberDelete(rec, $index)"><i class="fa fa-trash-o"></i></button>
											</td>
										</tr>
									</tbody>
								</table>

								<dir-pagination-controls
							       max-size="10"
							       direction-links="true"
							       boundary-links="true" >
							    </dir-pagination-controls>
							</div><!--end .table-responsive -->
						</div><!--end .col -->
					</div><!--end .row -->
					<!-- END DATATABLE 1 -->
				</div><!--end .section-body -->
			</section>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/js/angular.min.js') !!}
  	{!! HTML::script('backend/js/dirPagination.js') !!}
  	{!! HTML::script('backend/assets/js/jquery-ui.js') !!}
  	{!! HTML::script('backend/js/angular-select2.min.js') !!}
	<script>
		$(document).ready(function(){
	    	$("#dateFrom").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$("#dateTo").datepicker( "option", "minDate", selectedDate );
		      	}
		    });

		    $( "#dateTo" ).datepicker({
		      	dateFormat:'yy-mm-dd',
		      	changeMonth: false,
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$( "#dateFrom" ).datepicker( "option", "maxDate", selectedDate );
		      	}
		    });
		});/* end of ready function */

		var app = angular.module('appliedMembersFilter',['angularUtils.directives.dirPagination', 'ui.select2']);
		app.controller('appliedMembersController', function($timeout, $scope, $http){
			
			// $timeout(function(){
			// 	$scope.searchAppliedMembers();
			// },500);

			$scope.params = {};
	        $scope.params.dateFrom = '';
	        $scope.params.dateTo = '';
	        $scope.params.membershipID = '';
	        $scope.params.membership = '';
	      
			$scope.searchAppliedMembers = function(event) {
				event.preventDefault();
				angular.element(document.querySelector('.processLoadingDiv')).show();
				angular.element(document.querySelector('#appliedMembersTable')).hide();
				angular.element(document.querySelector('#displayError')).hide();
				$scope.records = [];
				$scope.recordArray = [10, 25, 50, 100];
				$http({
		          	method  : 'POST',
		          	url     : '/admin/members/applied/post',
		          	data    : $scope.params,
		        }).success(function(data){
		         	console.log(data);
		         	$scope.originaldata = data;
					$scope.datalength = $scope.originaldata.length;

					if($scope.datalength > 0){
						$scope.records = $scope.originaldata;
						angular.element(document.querySelector('.processLoadingDiv')).hide();
						angular.element(document.querySelector('#appliedMembersTable')).show();
					}else{
						angular.element(document.querySelector('.processLoadingDiv')).hide();
						angular.element(document.querySelector('#appliedMembersTable')).hide();
		         		swal("No Records!", "No Records Found", "info");
		         		return false;
					}
				});
			}

			$scope.clickAppliedMemberStatus = function(rec){
		        swal({
		            title: "Are you sure?",
		            text: "Do you really want to change this member's status?",
		            type: "warning",
		            showCancelButton: true,
		            confirmButtonColor: "#EE2C47",
		            confirmButtonText: "Yes",
		            cancelButtonText: "No",
		            closeOnConfirm: false,
		            closeOnCancel: false
	        	},
		        function(isConfirm){
	            	if(!isConfirm){
	              		swal("Cancelled", "This member's status is not being changed:)", "info");
	              		return false;
	            	}

	            	$(".processLoadingDiv").show();
		            $http.post('/admin/members/applied/status/post', {id: rec.id}).then(function(response){
		              	console.log(response.data);
		              	if(response.data.status == 'success'){
			                swal("Success!", "This member's status successfully changed to "+response.data.current+"!!!", 'success');
			                rec.status = response.data.current;
			            }

			            if(response.data.status == 'failure'){
			                swal("Error", "Error processing your request", 'error');
			            }
		              	$(".processLoadingDiv").hide();
		              	return false;
		            }, function(e){
		              	console.log(e);
		              	swal('Error', 'Error processing your request. Please contact system administrator', 'error');
		              	$(".processLoadingDiv").hide();
		              	return false;
		            });
	            });/* end of confirm function */
				return false;
		    }

			$scope.clickAppliedMemberDelete = function(rec, index){
		        swal({
		            title: "Are you sure?",
		            text: "Do you really want to delete this member's details?",
		            type: "warning",
		            showCancelButton: true,
		            confirmButtonColor: "#EE2C47",
		            confirmButtonText: "Yes",
		            cancelButtonText: "No",
		            closeOnConfirm: false,
		            closeOnCancel: false
	        	},
		        function(isConfirm){
	            	if(!isConfirm){
	              		swal("Cancelled", "This member's details are not being deleted:)", "error");
	              		return false;
	            	}

	            	$(".processLoadingDiv").show();
		            $http.post('/admin/members/applied/delete/post', {id: rec.id}).then(function(response){
		              	console.log(response.data);
		              	if(response.data.status == 'success'){
		                	$scope.records.splice(index, 1);
		                	swal('Success!!!', 'Selected member has been deleted successfully!!!', 'success');
		              	}else{
		                	swal('Error', 'Error processing your request. Please contact system administrator', 'error');
		              	}
		              	$(".processLoadingDiv").hide();
		              	return false;
		            }, function(e){
		              	console.log(e);
		              	swal('Error', 'Error processing your request. Please contact system administrator', 'error');
		              	$(".processLoadingDiv").hide();
		              	return false;
		            });
	            });/* end of confirm function */
				return false;
	      	}

			$scope.sort = function(keyname){
		        $scope.sortKey = keyname;   //set the sortKey to the param passed
		        $scope.reverse = !$scope.reverse; //if true make it false and vice versa
		    }
		});

		app.filter('capitalize', function() {
		    return function(input) {
		      return (!!input) ? input.charAt(0).toUpperCase() + input.substr(1).toLowerCase() : '';
		    }
		});

		app.filter('secondsToDateTime', function() {
		    return function(seconds) {
		        var d = new Date(0,0,0,0,0,0,0);
		        d.setSeconds(seconds);
		        return d;
		    };
		});
	</script>
@stop