<?php 
	use App\Models\CustomPages; 
	use App\Models\Option; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active">{!! CustomPages::getcontent("membershipMainPageTitle") !!}</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">{!! CustomPages::getcontent("membershipMainPageTitle") !!}</h1>
					</div><!--end .col -->
					
					<div class="clearfix"></div>
					
					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

					<div class="col-lg-12 col-md-12">
						{!! Form::open(["url"=>"admin/members/first/page/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]) !!}
							<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-8 col-lg-8">
							                <div class="form-group @if($errors->has('membershipMainPageTitle'))has-error @endif">
												{!! Form::text("membershipMainPageTitle",CustomPages::getcontent("membershipMainPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]) !!}
												@if($errors->has("membershipMainPageTitle"))
													<span id="membershipMainPageTitle-error" class="help-block">{!! $errors->first("membershipMainPageTitle") !!}</span>
												@endif
												{!! HTML::decode(Form::label("membershipMainPageTitle","Page Title <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-4 col-lg-4 brd-left">
						                  	<div class="text-right">
						                    	{!! Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']) !!}
						                    	<?php
						                    		$data = CustomPages::where("fieldName", "membershipMainPageTitle")->first();
						                    	?>
					                    		@if($data)
					                    			<p><b>Last Modified:</b>  {!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})</p>
					                    		@endif
						                      
						                  	</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-6 col-lg-6">
						                	<div class="form-group @if($errors->has('membershipPageWidgetOneDescription'))has-error @endif">
											{!! HTML::decode(Form::label("membershipPageWidgetOneDescription","First Widget Text <span class='text-danger'>*</span>")) !!}
											{!! Form::textarea("membershipPageWidgetOneDescription",CustomPages::getcontent("membershipPageWidgetOneDescription"),["class"=>"form-control"]) !!}
												@if($errors->has("membershipPageWidgetOneDescription"))
												<span id="membershipPageWidgetOneDescription-error" class="help-block">{!! $errors->first("membershipPageWidgetOneDescription") !!}</span>
												@endif
											</div>
						                </div>

						                <div class="col-md-6 col-lg-6">
						                	<div class="form-group @if($errors->has('membershipWidgetTwoDescription'))has-error @endif">
											{!! HTML::decode(Form::label("membershipWidgetTwoDescription","Second Widget Text <span class='text-danger'>*</span>"),["id"=>"membershipWidgetTwoDescription"]) !!}
											{!! Form::textarea("membershipWidgetTwoDescription",CustomPages::getcontent("membershipWidgetTwoDescription"),["class"=>"form-control"]) !!}
												@if($errors->has("membershipWidgetTwoDescription"))
												<span id="membershipWidgetTwoDescription-error" class="help-block">{!! $errors->first("membershipWidgetTwoDescription") !!}</span>
												@endif
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-6 col-lg-6">
							                <div class="form-group @if($errors->has('uploadMembershipRegForm'))has-error @endif">
												{!! Form::file("uploadMembershipRegForm",["class"=>"form-control"]) !!}
												@if($errors->has("uploadMembershipRegForm"))
													<span id="uploadMembershipRegForm-error" class="help-block">{!! $errors->first("uploadMembershipRegForm") !!}</span>
												@endif
												{!! HTML::decode(Form::label("uploadMembershipRegForm","Upload Membership Registration Form <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-6 col-lg-6">
						                	<div class="form-group @if($errors->has('uploadMembershipRenewalForm'))has-error @endif">
												{!! HTML::decode(Form::label("uploadMembershipRenewalForm","Upload Membership Renewal Form <span class='text-danger'>*</span>"),["id"=>"uploadMembershipRenewalForm"]) !!}
												{!! Form::file("uploadMembershipRenewalForm",["class"=>"form-control"]) !!}
												@if($errors->has("uploadMembershipRenewalForm"))
													<span id="uploadMembershipRenewalForm-error" class="help-block">{!! $errors->first("uploadMembershipRenewalForm") !!}</span>
												@endif
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>
				        {!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/iframe-transport.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/jquery-ui.js') !!}
	<script type="text/javascript">
	    $(document).ready(function(){
	      	CKEDITOR.replace('membershipPageWidgetOneDescription');
	      	CKEDITOR.replace('membershipWidgetTwoDescription');
	    });
	</script>
@stop