<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>
@extends("backend/master")
@section('styles')
	{!! HTML::style('backend/assets/css/jquery-ui.css') !!}
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">News</li>
					<li class="active">Modify News</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Modify News</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/news/get","Manage Posts",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/news/modify/post/".$news->id,"class"=>"form","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Modify Post</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									<div class="form-group @if($errors->has('postTitle'))has-error @endif">
										{!! Form::text("postTitle",$news->newsTitle,["class"=>"form-control"]) !!}
											@if($errors->has("postTitle"))
												<span id="postTitle-error" class="help-block">{!! $errors->first("postTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("postTitle","Title <span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('newsDate'))has-error @endif">
										{!! Form::text("newsDate", $news->newsDate,["class"=>"form-control", 'id'=>'newsDate']) !!}
											@if($errors->has("newsDate"))
												<span id="newsDate-error" class="help-block">{!! $errors->first("newsDate") !!}</span>
											@endif
										{!! HTML::decode(Form::label("newsDate","Date <span class='text-danger'>*</span>")) !!}
									</div>
										
									<div class="form-group @if($errors->has('postDescription'))has-error @endif">
										
										{!! Form::textarea("postDescription",$news->newsContent,["class"=>"form-control"]) !!}
										@if($errors->has("postDescription"))
											<span id="postDescription-error" class="help-block">{!! $errors->first("postDescription") !!}</span>
										@endif
										{!! HTML::decode(Form::label("postDescription","Short Description <span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('postCategories'))has-error @endif">
										{!! Form::select("postCategories[]",$categories,explode(",", $news->newsCategories),["class"=>"form-control","id"=>"postCategories","multiple"]) !!}
										@if($errors->has("postCategories"))
											<span id="postCategories-error" class="help-block">{!! $errors->first("postCategories") !!}</span>
										@endif
										{!! HTML::decode(Form::label("postCategories","Category<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('postAuthor'))has-error @endif">
										{!! Form::select("postAuthor",$authors,$news->newsAuthorID,["class"=>"form-control","id"=>"postAuthor","placeholder"=>"Select Author"]) !!}
										@if($errors->has("postAuthor"))
											<span id="postAuthor-error" class="help-block">{!! $errors->first("postAuthor") !!}</span>
										@endif
										{!! HTML::decode(Form::label("postAuthor","Author<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('postSettings'))has-error @endif">
										<div class="checkbox checkbox-styled">
											<label>
												{!! Form::checkbox("postSettings","yes",$news->newsSettings == "yes",["class"=>""]) !!}
												<span>Display this news in home page</span>
											</label>
										</div>
									</div>

									<div class="form-group @if($errors->has('newsLink'))has-error @endif">
										{!! Form::text("newsLink", $news->news_link,["class"=>"form-control"]) !!}
											@if($errors->has("newsLink"))
												<span id="newsLink-error" class="help-block">{!! $errors->first("newsLink") !!}</span>
											@endif
										{!! HTML::decode(Form::label("newsLink","News Link <span class='text-danger'>*</span>")) !!}
									</div>

									{{-- <div class="form-group @if($errors->has('featureImage'))has-error @endif">
									<div class="row">
										<div class="col-lg-3">
											@if($news->featureImage != "")
												{!! HTML::image($news->featureImage,$news->postTitle,["class"=>"img-responsive admin_img"]) !!}
											@endif
										</div>	
										
										@if($errors->has("featureImage"))
											<span id="featureImage-error" class="help-block">{!! $errors->first("featureImage") !!}</span>
										@endif

										<div class="col-lg-5">
											{!! HTML::decode(Form::label("featureImage","Featured Image")) !!}
											{!! Form::file("featureImage",["class"=>"form-control"]) !!}
											<p class="help-block">Recommended Image Resolution 850px x 450px</p>
											@if($errors->has("featureImage"))
												<span id="featureImage-error" class="help-block">{!! $errors->first("featureImage") !!}</span>
											@endif
										</div>
									</div>
									</div> --}}
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Modify News</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/assets/js/jquery-ui.js') !!}
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	    	$("#newsDate").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1
		    });
	      //CKEDITOR.replace('postDescription');
	    });
	</script>
@stop