<?php 
	use App\Models\CustomPages; 
	use App\Models\Option;
?>
@extends("backend/master")
@section('styles')
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css') !!}
@stop

@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">All Pages</li>
				</ol>
			</div>
			<div class="section-header">
				<div class="row">
					<div class="col-lg-12">
						<h2 class="text-primary">All Pages</h2>
					</div>
				</div>
			</div>

			<div class="section-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Page Name</th>
										<th>Last Modified On</th>
										<th class="sort-alpha">Actions</th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<?php
											$data = CustomPages::where("fieldName", "privacyPolicyPageTitle")->first();
										?>
										<td>1</td>
										<td>{!! CustomPages::getcontent("privacyPolicyPageTitle") !!}</td>
										@if($data)
											<td>{!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})</td>
											<td><a href="{!! URL::to('admin/pages/privacypolicy/get') !!}">
											<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
											</a></td>
										@else
											<td></td>
											<td></td>
										@endif
									</tr>

									<tr>
										<?php
											$data = CustomPages::where("fieldName", "termsAndConditionsPageTitle")->first();
										?>
										<td>2</td>
										<td>{!! CustomPages::getcontent("termsAndConditionsPageTitle") !!}</td>
										@if($data)
											<td>{!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})</td>
											<td><a href="{!! URL::to('admin/pages/termsandconditions/get') !!}">
											<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
											</a></td>
										@else
											<td></td>
											<td></td>
										@endif
									</tr>

									<tr>
										<?php
											$data = CustomPages::where("fieldName", "returnPolicyPageTitle")->first();
										?>
										<td>3</td>
										<td>{!! CustomPages::getcontent("returnPolicyPageTitle") !!}</td>
										@if($data)
											<td>{!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})</td>
											<td><a href="{!! URL::to('admin/pages/returnpolicy/get') !!}">
											<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
											</a></td>
										@else
											<td></td>
											<td></td>
										@endif
									</tr>

									<tr>
										<?php
											$data = CustomPages::where("fieldName", "contactUsPageTitle")->first();
										?>
										<td>4</td>
										<td>{!! CustomPages::getcontent("contactUsPageTitle") !!}</td>
										@if($data)
											<td>{!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})</td>
											<td><a href="{!! URL::to('admin/pages/contactus/get') !!}">
											<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
											</a></td>
										@else
											<td></td>
											<td></td>
										@endif
									</tr>
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->
			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js') !!}
	{!! HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js') !!}
	{!! HTML::script('backend/js/bala.js') !!}
	<script type="text/javascript">
		$(document).ready(function()
		{
	    	$('#myTable').DataTable();
		});
	</script>
@stop