<?php 
	use App\Models\CustomPages; 
	use App\Models\Option;
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active">{!! CustomPages::getcontent("contactUsPageTitle") !!}</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">{!! CustomPages::getcontent("contactUsPageTitle") !!}</h1>
					</div><!--end .col -->

					<div class="clearfix"></div>
					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
					
					<div class="col-lg-12 col-md-12">
						{!! Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]) !!}
								<div class="panel panel-default">
				        			<div class="panel-body">
				            			<div class="row">
				                			<div class="col-md-8 col-lg-8">
					                			<div class="form-group @if($errors->has('contactUsPageTitle'))has-error @endif">
													{!! Form::text("contactUsPageTitle",CustomPages::getcontent("contactUsPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]) !!}
													@if($errors->has("contactUsPageTitle"))
														<span id="contactUsPageTitle-error" class="help-block">{!! $errors->first("contactUsPageTitle") !!}</span>
													@endif
													{!! HTML::decode(Form::label("contactUsPageTitle","Page Title <span class='text-danger'>*</span>")) !!}
												</div>
				                			</div>

							                <?php
					                    		$data = CustomPages::where("fieldName", "contactUsPageTitle")->first();
					                    	?>

							                <div class="col-md-4 col-lg-4 brd-left">
							                  	<div class="text-right">
							                    	{{ Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']) }}
								                    @if($data)
						                    			<p>
						                    				<b>Last Modified:</b>  {!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})
						                    			</p>
						                    		@endif
							                  	</div>
							                </div>
				            			</div>
				        			</div>
				        		</div>

				        <div class="panel panel-default">
				        	<div class="panel-body">
				            	<div class="row">
				                	<div class="col-md-12 col-lg-12">
					                	<div class="form-group @if($errors->has('contactUsAddress'))has-error @endif">
											{!! Form::textarea("contactUsAddress",CustomPages::getcontent("contactUsAddress"),["class"=>"form-control","placeholder"=>"enter address","rows"=>"4"]) !!}
											@if($errors->has("contactUsAddress"))
												<span id="contactUsAddress-error" class="help-block">{!! $errors->first("contactUsAddress") !!}</span>
											@endif
											{!! HTML::decode(Form::label("contactUsAddress","Address <span class='text-danger'>*</span>")) !!}
										</div>
				                	</div>
				            	</div>
				        	</div>
				        </div>

				        <div class="panel panel-default">
				        	<div class="panel-body">
				            	<div class="row">
				                	<div class="col-md-12 col-lg-12">
						                <div class="form-group @if($errors->has('contactUsPhone'))has-error @endif">
											{!! Form::text("contactUsPhone",CustomPages::getcontent("contactUsPhone"),["class"=>"form-control","placeholder"=>"enter phone"]) !!}
											@if($errors->has("contactUsPhone"))
												<span id="contactUsPhone-error" class="help-block">{!! $errors->first("contactUsPhone") !!}</span>
											@endif
											{!! HTML::decode(Form::label("contactUsPhone","Phone <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group @if($errors->has('contactUsFax'))has-error @endif">
											{!! Form::text("contactUsFax",CustomPages::getcontent("contactUsFax"),["class"=>"form-control","placeholder"=>"enter fax"]) !!}
											@if($errors->has("contactUsFax"))
												<span id="contactUsFax-error" class="help-block">{!! $errors->first("contactUsFax") !!}</span>
											@endif
											{!! HTML::decode(Form::label("contactUsFax","Fax <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group @if($errors->has('contactUsEmail'))has-error @endif">
											{!! Form::text("contactUsEmail",CustomPages::getcontent("contactUsEmail"),["class"=>"form-control","placeholder"=>"enter email"]) !!}
											@if($errors->has("contactUsEmail"))
												<span id="contactUsEmail-error" class="help-block">{!! $errors->first("contactUsEmail") !!}</span>
											@endif
											{!! HTML::decode(Form::label("contactUsEmail","E-Mail <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group @if($errors->has('contactUsMap'))has-error @endif">
											{!! Form::textarea("contactUsMap",CustomPages::getcontent("contactUsMap"),["class"=>"form-control","placeholder"=>"enter map embedd","rows"=>"4"]) !!}
											@if($errors->has("contactUsMap"))
											<span id="contactUsMap-error" class="help-block">{!! $errors->first("contactUsMap") !!}</span>
											@endif
											{!! HTML::decode(Form::label("contactUsMap","Map Embedd Code <span class='text-danger'>*</span>")) !!}
										</div>
				                	</div>
				            </div>
				        </div>
				        </div>

				        <div class="panel panel-default">
			        		<div class="panel-body">
			            		<div class="row">
			            			<div class="col-md-12 col-lg-12">
				                		<h4 class="text-primary"><b>Search Engine Optimization</b></h4>

										<div class="form-group">
											{!! Form::text("contactUsMetaTitle",CustomPages::getcontent("contactUsMetaTitle"),["class"=>"form-control","placeholder"=>"Meta Title","rows"=>"4"]) !!}
											@if($errors->has("contactUsMetaTitle"))
												<span id="contactUsMetaTitle-error" class="help-block">{!! $errors->first("contactUsMetaTitle") !!}</span>
											@endif
											{!! HTML::decode(Form::label("contactUsMetaTitle","Meta Title <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group">
											{!! Form::textarea("contactUsMetaDescription",CustomPages::getcontent("contactUsMetaDescription"),["class"=>"form-control","placeholder"=>"Meta Description","rows"=>"4"]) !!}
											@if($errors->has("contactUsMetaDescription"))
												<span id="contactUsMetaDescription-error" class="help-block">{!! $errors->first("contactUsMetaDescription") !!}</span>
											@endif
											{!! HTML::decode(Form::label("contactUsMetaDescription","Meta Description <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group">
											{!! Form::text("contactUsMetaKeywords",CustomPages::getcontent("contactUsMetaKeywords"),["class"=>"form-control","placeholder"=>"Meta Keywords","rows"=>"4"]) !!}
											@if($errors->has("contactUsMetaKeywords"))
												<span id="contactUsMetaKeywords-error" class="help-block">{!! $errors->first("contactUsMetaKeywords") !!}</span>
											@endif
											{!! HTML::decode(Form::label("contactUsMetaKeywords","Meta Keywords <span class='text-danger'>*</span>")) !!}
											<p class="help-block">Enter keywords seperated with comma</p>
										</div>
									</div>
								</div>
							</div>
						</div>

				        {!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	      CKEDITOR.replace('aboutdetailsOne');
	      CKEDITOR.replace('aboutdetailsTwo');
	    });
	</script>
@stop