<?php 
	use App\Models\CustomPages; 
	use App\Models\Option;
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active">{!! CustomPages::getcontent("disclaimerPageTitle") !!}</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">{!! CustomPages::getcontent("disclaimerPageTitle") !!}</h1>
					</div><!--end .col -->

					<div class="clearfix"></div>
					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

					<div class="col-lg-12 col-md-12">
						{!! Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data"]) !!}
						<div class="panel panel-default">
				        <div class="panel-body">
				            <div class="row">
				                <div class="col-md-8 col-lg-8">
					                <div class="form-group @if($errors->has('disclaimerPageTitle'))has-error @endif">
										{!! Form::text("disclaimerPageTitle",CustomPages::getcontent("disclaimerPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]) !!}
											@if($errors->has("disclaimerPageTitle"))
												<span id="disclaimerPageTitle-error" class="help-block">{!! $errors->first("disclaimerPageTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("pageTitle","Page Title <span class='text-danger'>*</span>")) !!}
									</div>
				                </div>

				                <?php
		                    		$data = CustomPages::where("fieldName", "disclaimerPageTitle")->first();
		                    	?>

				                <div class="col-md-4 col-lg-4 brd-left">
				                  	<div class="text-right">
				                    	{{ Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']) }}
				                      	@if($data)
			                    			<p>
			                    				<b>Last Modified:</b>  {!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})
			                    			</p>
			                    		@endif
				                  	</div>
				                </div>
				            </div>
				        </div>
				        </div>

				        <div class="panel panel-default">
					        <div class="panel-body">
					            <div class="row">
					                <div class="col-md-12 col-lg-12">
					                	<div class="form-group @if($errors->has('disclaimerPageContent'))has-error @endif">
											{!! HTML::decode(Form::label("disclaimerPageContent","Content <span class='text-danger'>*</span>")) !!}
											{!! Form::textarea("disclaimerPageContent",CustomPages::getcontent("disclaimerPageContent"),["class"=>"form-control","cols"=>20,"rows"=>20]) !!}
											@if($errors->has("disclaimerPageContent"))
												<span id="disclaimerPageContent-error" class="help-block">{!! $errors->first("disclaimerPageContent") !!}</span>
											@endif
										</div>
					                </div>
					            </div>
					        </div>
				        </div>

				        <div class="panel panel-default">
			        		<div class="panel-body">
			            		<div class="row">
			            			<div class="col-md-12 col-lg-12">
				                		<h4 class="text-primary"><b>Search Engine Optimization</b></h4>

										<div class="form-group">
											{!! Form::text("disclaimerPageMetaTitle",CustomPages::getcontent("disclaimerPageMetaTitle"),["class"=>"form-control","placeholder"=>"Meta Title","rows"=>"4"]) !!}
											@if($errors->has("disclaimerPageMetaTitle"))
												<span id="disclaimerPageMetaTitle-error" class="help-block">{!! $errors->first("disclaimerPageMetaTitle") !!}</span>
											@endif
											{!! HTML::decode(Form::label("disclaimerPageMetaTitle","Meta Title <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group">
											{!! Form::textarea("disclaimerPageMetaDescription",CustomPages::getcontent("disclaimerPageMetaDescription"),["class"=>"form-control","placeholder"=>"Meta Description","rows"=>"4"]) !!}
											@if($errors->has("disclaimerPageMetaDescription"))
												<span id="disclaimerPageMetaDescription-error" class="help-block">{!! $errors->first("disclaimerPageMetaDescription") !!}</span>
											@endif
											{!! HTML::decode(Form::label("disclaimerPageMetaDescription","Meta Description <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group">
											{!! Form::text("disclaimerPageMetaKeywords",CustomPages::getcontent("disclaimerPageMetaKeywords"),["class"=>"form-control","placeholder"=>"Meta Keywords","rows"=>"4"]) !!}
											@if($errors->has("disclaimerPageMetaKeywords"))
												<span id="disclaimerPageMetaKeywords-error" class="help-block">{!! $errors->first("disclaimerPageMetaKeywords") !!}</span>
											@endif
											{!! HTML::decode(Form::label("disclaimerPageMetaKeywords","Meta Keywords <span class='text-danger'>*</span>")) !!}
											<p class="help-block">Enter keywords seperated with comma</p>
										</div>
									</div>
								</div>
							</div>
						</div>

				        {!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	      CKEDITOR.replace('disclaimerPageContent');
	    });
	</script>
@stop