<?php 
	use App\Models\CustomPages; 
	use App\Models\Option;
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active">{!! CustomPages::getcontent("privacyPolicyPageTitle") !!}</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">{!! CustomPages::getcontent("privacyPolicyPageTitle") !!}</h1>
					</div><!--end .col -->

					<div class="clearfix"></div>
					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

					<div class="col-lg-12 col-md-12">
						{!! Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data"]) !!}
						<div class="panel panel-default">
				        <div class="panel-body">
				            <div class="row">
				                <div class="col-md-8 col-lg-8">
					                <div class="form-group @if($errors->has('privacyPolicyPageTitle'))has-error @endif">
										{!! Form::text("privacyPolicyPageTitle",CustomPages::getcontent("privacyPolicyPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]) !!}
											@if($errors->has("privacyPolicyPageTitle"))
												<span id="privacyPolicyPageTitle-error" class="help-block">{!! $errors->first("privacyPolicyPageTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("pageTitle","Page Title <span class='text-danger'>*</span>")) !!}
									</div>
				                </div>

				                <?php
		                    		$data = CustomPages::where("fieldName", "privacyPolicyPageTitle")->first();
		                    	?>

				                <div class="col-md-4 col-lg-4 brd-left">
				                  	<div class="text-right">
				                    	{{ Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']) }}
				                      	@if($data)
			                    			<p>
			                    				<b>Last Modified:</b>  {!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})
			                    			</p>
			                    		@endif
				                  	</div>
				                </div>
				            </div>
				        </div>
				        </div>

				        <div class="panel panel-default">
					        <div class="panel-body">
					            <div class="row">
					                <div class="col-md-12 col-lg-12">
					                	<div class="form-group @if($errors->has('privacyPolicyPageContent'))has-error @endif">
											{!! HTML::decode(Form::label("privacyPolicyPageContent","Content <span class='text-danger'>*</span>")) !!}
											{!! Form::textarea("privacyPolicyPageContent",CustomPages::getcontent("privacyPolicyPageContent"),["class"=>"form-control","cols"=>20,"rows"=>20]) !!}
											@if($errors->has("privacyPolicyPageContent"))
												<span id="privacyPolicyPageContent-error" class="help-block">{!! $errors->first("privacyPolicyPageContent") !!}</span>
											@endif
										</div>
					                </div>
					            </div>
					        </div>
				        </div>

				        <div class="panel panel-default">
			        		<div class="panel-body">
			            		<div class="row">
			            			<div class="col-md-12 col-lg-12">
				                		<h4 class="text-primary"><b>Search Engine Optimization</b></h4>

										<div class="form-group">
											{!! Form::text("privacyPolicyMetaTitle",CustomPages::getcontent("privacyPolicyMetaTitle"),["class"=>"form-control","placeholder"=>"Meta Title","rows"=>"4"]) !!}
											@if($errors->has("privacyPolicyMetaTitle"))
												<span id="privacyPolicyMetaTitle-error" class="help-block">{!! $errors->first("privacyPolicyMetaTitle") !!}</span>
											@endif
											{!! HTML::decode(Form::label("privacyPolicyMetaTitle","Meta Title <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group">
											{!! Form::textarea("privacyPolicyMetaDescription",CustomPages::getcontent("privacyPolicyMetaDescription"),["class"=>"form-control","placeholder"=>"Meta Description","rows"=>"4"]) !!}
											@if($errors->has("privacyPolicyMetaDescription"))
												<span id="privacyPolicyMetaDescription-error" class="help-block">{!! $errors->first("privacyPolicyMetaDescription") !!}</span>
											@endif
											{!! HTML::decode(Form::label("privacyPolicyMetaDescription","Meta Description <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group">
											{!! Form::text("privacyPolicyMetaKeywords",CustomPages::getcontent("privacyPolicyMetaKeywords"),["class"=>"form-control","placeholder"=>"Meta Keywords","rows"=>"4"]) !!}
											@if($errors->has("privacyPolicyMetaKeywords"))
												<span id="privacyPolicyMetaKeywords-error" class="help-block">{!! $errors->first("privacyPolicyMetaKeywords") !!}</span>
											@endif
											{!! HTML::decode(Form::label("privacyPolicyMetaKeywords","Meta Keywords <span class='text-danger'>*</span>")) !!}
											<p class="help-block">Enter keywords seperated with comma</p>
										</div>
									</div>
								</div>
							</div>
						</div>

				        {!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	      CKEDITOR.replace('privacyPolicyPageContent');
	    });
	</script>
@stop