<?php 
	use App\Models\CustomPages; 
	use App\Models\Option;
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active">{!! CustomPages::getcontent("shippingPolicyPageTitle") !!}</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">{!! CustomPages::getcontent("shippingPolicyPageTitle") !!}</h1>
					</div><!--end .col -->

					<div class="clearfix"></div>
					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

					<div class="col-lg-12 col-md-12">
						{!! Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data"]) !!}
						<div class="panel panel-default">
				        <div class="panel-body">
				            <div class="row">
				                <div class="col-md-8 col-lg-8">
					                <div class="form-group @if($errors->has('shippingPolicyPageTitle'))has-error @endif">
										{!! Form::text("shippingPolicyPageTitle",CustomPages::getcontent("shippingPolicyPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]) !!}
											@if($errors->has("shippingPolicyPageTitle"))
												<span id="shippingPolicyPageTitle-error" class="help-block">{!! $errors->first("shippingPolicyPageTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("pageTitle","Page Title <span class='text-danger'>*</span>")) !!}
									</div>
				                </div>

				                <?php
		                    		$data = CustomPages::where("fieldName", "shippingPolicyPageTitle")->first();
		                    	?>

				                <div class="col-md-4 col-lg-4 brd-left">
				                  	<div class="text-right">
				                    	{{ Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']) }}
				                      	@if($data)
			                    			<p>
			                    				<b>Last Modified:</b>  {!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})
			                    			</p>
			                    		@endif
				                  	</div>
				                </div>
				            </div>
				        </div>
				        </div>

				        <div class="panel panel-default">
					        <div class="panel-body">
					            <div class="row">
					                <div class="col-md-12 col-lg-12">
					                	<div class="form-group @if($errors->has('shippingPolicyPageContent'))has-error @endif">
											{!! HTML::decode(Form::label("shippingPolicyPageContent","Content <span class='text-danger'>*</span>")) !!}
											{!! Form::textarea("shippingPolicyPageContent",CustomPages::getcontent("shippingPolicyPageContent"),["class"=>"form-control","cols"=>20,"rows"=>20]) !!}
											@if($errors->has("shippingPolicyPageContent"))
												<span id="shippingPolicyPageContent-error" class="help-block">{!! $errors->first("shippingPolicyPageContent") !!}</span>
											@endif
										</div>
					                </div>
					            </div>
					        </div>
				        </div>

				        <div class="panel panel-default">
			        		<div class="panel-body">
			            		<div class="row">
			            			<div class="col-md-12 col-lg-12">
				                		<h4 class="text-primary"><b>Search Engine Optimization</b></h4>

										<div class="form-group">
											{!! Form::text("shippingPolicyPageMetaTitle",CustomPages::getcontent("shippingPolicyPageMetaTitle"),["class"=>"form-control","placeholder"=>"Meta Title","rows"=>"4"]) !!}
											@if($errors->has("shippingPolicyPageMetaTitle"))
												<span id="shippingPolicyPageMetaTitle-error" class="help-block">{!! $errors->first("shippingPolicyPageMetaTitle") !!}</span>
											@endif
											{!! HTML::decode(Form::label("shippingPolicyPageMetaTitle","Meta Title <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group">
											{!! Form::textarea("shippingPolicyPageMetaDescription",CustomPages::getcontent("shippingPolicyPageMetaDescription"),["class"=>"form-control","placeholder"=>"Meta Description","rows"=>"4"]) !!}
											@if($errors->has("shippingPolicyPageMetaDescription"))
												<span id="shippingPolicyPageMetaDescription-error" class="help-block">{!! $errors->first("shippingPolicyPageMetaDescription") !!}</span>
											@endif
											{!! HTML::decode(Form::label("shippingPolicyPageMetaDescription","Meta Description <span class='text-danger'>*</span>")) !!}
										</div>

										<div class="form-group">
											{!! Form::text("shippingPolicyPageMetaKeywords",CustomPages::getcontent("shippingPolicyPageMetaKeywords"),["class"=>"form-control","placeholder"=>"Meta Keywords","rows"=>"4"]) !!}
											@if($errors->has("shippingPolicyPageMetaKeywords"))
												<span id="shippingPolicyPageMetaKeywords-error" class="help-block">{!! $errors->first("shippingPolicyPageMetaKeywords") !!}</span>
											@endif
											{!! HTML::decode(Form::label("shippingPolicyPageMetaKeywords","Meta Keywords <span class='text-danger'>*</span>")) !!}
											<p class="help-block">Enter keywords seperated with comma</p>
										</div>
									</div>
								</div>
							</div>
						</div>

				        {!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	      CKEDITOR.replace('shippingPolicyPageContent');
	    });
	</script>
@stop