<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>
@extends("backend/master")

@section('styles')
	{!! HTML::style('backend/assets/css/jquery-ui.css') !!}
@stop

@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content" ng-app="AdclubMadras" ng-controller="entryTicketReportController">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li>Reports</li>
					<li>Entry Ticket Reports</li>
				</ol>
			</div>

			<div id="exclUploadDiv">
		      	<div class="card">
		        	<div class="card-body">
		          		<div class="row">
		            		{!! Form::open(["name"=>"entryTicketReportSearchForm"]) !!}
		            			<div class="col-lg-3">
		              				{!! Form::text("dateFrom","",["class"=>"form-control","id"=>"dateFrom","placeholder"=>"From Date","ng-model"=>"params.dateFrom", 'autocomplete'=>'off']) !!}
					              	@if($errors->has("dateFrom"))
										<span id="dateFrom-error" class="help-block">{!! $errors->first("dateFrom") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				{!! Form::text("dateTo","",["class"=>"form-control","id"=>"dateTo","placeholder"=>"To Date","ng-model"=>"params.dateTo", 'autocomplete'=>'off']) !!}
					              	@if($errors->has("dateTo"))
										<span id="dateTo-error" class="help-block">{!! $errors->first("dateTo") !!}</span>
									@endif
		            			</div>

		            			<div class="clearfix"></div>	
		            			<br>
		            			
					            <div class="col-lg-2">
					                <input type="submit" class="btn ink-reaction btn-success" ng-click="entryTicketReportSearchClick($event)" value="Search">
									
					                <input type="reset" class="btn ink-reaction btn-danger" value="Reset">
					            </div>
		            		{!! Form::close() !!}
		          		</div>
		        	</div>
		      	</div>
		  	</div>

		  	<div class="clearfix"></div>

  			@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

  			<div class="processLoadingDiv" style='display:none'>
		        <div class="spinner">
				  <div class="bounce1"></div>
				  <div class="bounce2"></div>
				  <div class="bounce3"></div>
				</div>
		        <p class="text-center">Processing.... Please wait...</p>
		    </div>

			<section id="entryTicketReportsTable" style="display:none">

				<div class="section-header">
					<div class="row">
						<div class="col-lg-6">
							<h2 class="text-primary">Entry Ticket Report</h2>
						</div>

						<div class="col-lg-6">
							<button type="button" class="btn ink-reaction btn-sm btn-primary pull-right" ng-click="downloadExcelClick()">Download Excel</button>
						</div>
					</div>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="col-lg-12">
							<div class="table-responsive">
								<div style="float: left;"><b>Shows</b> &nbsp;&nbsp;
									<select ng-model="recordLimit"  ng-init="recordLimit=10" ng-options="item for item in recordArray">
									</select>
								</div>

								<div style="float: right;"><b>Search</b> &nbsp;&nbsp;<input type="text" ng-model="filterSearch"></div>

								<table id="myTable" class="table table-striped table-hover">
									<thead>
										<tr>
											<th ng-click="sort('sno')">#</th>
											<th ng-click="sort('entryID')">Entry ID</th>
											<th ng-click="sort('name')">Name</th>
											<th ng-click="sort('email')">Email</th>
											<th ng-click="sort('tickets')">Tickets</th>
											<th ng-click="sort('amount')">Payable Amount (Rs.)</th>
											<th ng-click="sort('mode')">Payment Mode</th>
											<th ng-click="sort('trackingId')">Tracking ID</th>
											<th ng-click="sort('paymentDate')">Payment Date</th>
											<th ng-click="sort('contactNo')">contactNo</th>
											<th ng-click="sort('companyName')">Company Name</th>
										</tr>
									</thead>

									<tbody>
										<tr dir-paginate="rec in records |orderBy:sortKey:reverse | filter: filterSearch|itemsPerPage:recordLimit">
											<td>@{{ rec.sNo }}</td>
											<td>@{{ rec.entryID }}</td>
											<td>@{{ rec.name|capitalize }}</td>
											<td>@{{ rec.email }}</td>
											<td>@{{ rec.tickets }}</td>
											<td>@{{ rec.amount }}</td>
											<td>@{{ rec.mode }}</td>
											<td>@{{ rec.trackingId }}</td>
											<td>@{{ rec.paymentDate }}</td>
											<td>@{{ rec.contactNo }}</td>
											<td>@{{ rec.companyName }}</td>
										</tr>
									</tbody>
								</table>

								<dir-pagination-controls
							       max-size="10"
							       direction-links="true"
							       boundary-links="true" >
							    </dir-pagination-controls>
							</div><!--end .table-responsive -->
						</div><!--end .col -->
					</div><!--end .row -->
					<!-- END DATATABLE 1 -->
				</div><!--end .section-body -->
			</section>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/js/angular.min.js') !!}
  	{!! HTML::script('backend/js/dirPagination.js') !!}
  	{!! HTML::script('backend/assets/js/jquery-ui.js') !!}
  	{!! HTML::script('backend/js/angular-select2.min.js') !!}
	<script>
		$(document).ready(function(){
	    	$("#dateFrom").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$("#dateTo").datepicker( "option", "minDate", selectedDate );
		      	}
		    });

		    $( "#dateTo" ).datepicker({
		      	dateFormat:'yy-mm-dd',
		      	changeMonth: false,
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$( "#dateFrom" ).datepicker( "option", "maxDate", selectedDate );
		      	}
		    });
		});/* end of ready function */

		var app = angular.module('AdclubMadras',['angularUtils.directives.dirPagination', 'ui.select2']);
		app.controller('entryTicketReportController', function($timeout, $scope, $http){
			
			// $timeout(function(){
			// 	$scope.entryTicketReportSearchClick();
			// },500);

			$scope.params = {};
	        $scope.params.dateFrom = '';
	        $scope.params.dateTo = '';
	        $scope.params.orderID = '';
	        $scope.params.paymentStatus = '';
	      
			$scope.entryTicketReportSearchClick = function(event) {
				event.preventDefault();
				angular.element(document.querySelector('.processLoadingDiv')).show();
				angular.element(document.querySelector('#entryTicketReportsTable')).hide();
				angular.element(document.querySelector('#displayError')).hide();
				$scope.records = [];
				$scope.recordArray = [10, 25, 50, 100];
				$http({
		          	method  : 'POST',
		          	url     : '/admin/reports/entryticket/post',
		          	data    : $scope.params,
		        }).success(function(data){
		         	console.log(data);
		         	$scope.originaldata = data;
					$scope.datalength = $scope.originaldata.length;

					if($scope.datalength > 0){
						for(var i = 0; i < $scope.originaldata.length; i++){
							var sNo = i + 1;
							$scope.originaldata[i].sNo = sNo;
							$scope.records.push($scope.originaldata[i]);
						}
						angular.element(document.querySelector('.processLoadingDiv')).hide();
						angular.element(document.querySelector('#entryTicketReportsTable')).show();
					}else{
						angular.element(document.querySelector('.processLoadingDiv')).hide();
						angular.element(document.querySelector('#entryTicketReportsTable')).hide();
		         		swal("No Records!", "No Records Found", "info");
		         		return false;
					}
				}).error(function(e){
		         	console.log(e.responseText);;
		         	swal("Error!", "Error processing your request", "error");
		         	return false;
				});
			}

			$scope.sort = function(keyname){
		        $scope.sortKey = keyname;   //set the sortKey to the param passed
		        $scope.reverse = !$scope.reverse; //if true make it false and vice versa
		    }

		    $scope.downloadExcelClick = function(){
		    	$scope.params.URL = "/admin/reports/entryticket/excel/get";

		    	$scope.params.URL = $scope.params.URL+'?';

		    	if($scope.params.dateFrom != ""){
		    		$scope.params.URL = $scope.params.URL+'from='+$scope.params.dateFrom+"&&";
		    	}

		    	if($scope.params.dateTo != ""){
		    		$scope.params.URL = $scope.params.URL+'to='+$scope.params.dateTo+"&&";
		    	}
		        var win = window.open($scope.params.URL);
		        win.focus();
		    }
		});

		app.filter('capitalize', function() {
		    return function(input) {
		      return (!!input) ? input.charAt(0).toUpperCase() + input.substr(1).toLowerCase() : '';
		    }
		});

		app.filter('secondsToDateTime', function() {
		    return function(seconds) {
		        var d = new Date(0,0,0,0,0,0,0);
		        d.setSeconds(seconds);
		        return d;
		    };
		});
	</script>
@stop