@extends('backend/master')
<?php
use App\Models\Adminmenu;
use App\Models\Adminmenumanage;
?>
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/jquery-ui/jquery-ui-theme.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/nestable/nestable.css')!!}
@stop

@section('maincontent')
			<!-- BEGIN CONTENT-->
			<div id="content">

				<!-- BEGIN LIST SAMPLES -->
				<section>
					<div class="section-header">
						<ol class="breadcrumb">
							<li class="active">Home</li>
							<li class="active">Manage Admin Menu</li> 
						</ol>
					</div>
					<div class="section-body">

						<!-- BEGIN INTRO -->
						<div class="row">
							<div class="col-lg-12">
								<h1 class="text-primary">Manage Admin Menu</h1>
							</div><!--end .col -->
						</div><!--end .row -->
						<!-- END INTRO -->

						<!-- BEGIN NESTABLE LISTS -->
						<div class="row">
							<div class="col-lg-3 col-md-4">
								<div class="card">
								<div class="card-body">
								<div class="checkbox checkbox-inline checkbox-styled">
									<label><input type="checkbox" class="selectAllMenu"> Select All</label>
								</div>
								<form id="menuForm">
								@if(count($adminmenu) > 0)
								@foreach($adminmenu as $menu)
									<div class="checkbox checkbox-inline checkbox-styled">
										<label>
											@if(in_array($menu->id,explode(",", $activemenu)))
											<input type="checkbox" class="menuClass{!! $menu->id !!}" data-menuId="{!! $menu->id !!}" data-menuName="{!! $menu->menuname !!}" checked="checked"> {!! $menu->menuname !!}
											@else
											<input type="checkbox" class="menuClass{!! $menu->id !!}" data-menuId="{!! $menu->id !!}" data-menuName="{!! $menu->menuname !!}"> {!! $menu->menuname !!}
											@endif
										</label>
									</div>
									<div class="clearfix"></div>
								@endforeach
									@else
									No Adminmenu available.
									@endif
								</form>
								</div>
								</div>
							</div><!--end .col -->
							<div class="col-md-8">
								<div class="card">
									<div class="card-body">
										<div class="row">
											<div class="col-lg-12">
													<div class="dd nestable-list">
													<ol class="dd-list menuList">
														@if(count($menuOrder)>0)
														@foreach($menuOrder as $firstlevel)
														<li class="dd-item tile" data-id="{!! $firstlevel->menuId !!}">
															<div class="dd-handle btn btn-default-light">{!! Adminmenumanage::getmenuname($firstlevel->menuId)!!}</div>
															@if(Adminmenumanage::hasSubmenu($firstlevel->menuId)>0)
															<ol class="dd-list">
																@foreach(Adminmenumanage::getSubmenu($firstlevel->menuId) as $secondlevel)
																<li class="dd-item tile" data-id="{!! $secondlevel->menuId !!}">
																	<div class="dd-handle btn btn-default-light">{!! Adminmenumanage::getmenuname($secondlevel->menuId)!!}</div>

																	@if(Adminmenumanage::hasSubmenu($secondlevel->menuId)>0)
																	<ol class="dd-list">
																		@foreach(Adminmenumanage::getSubmenu($secondlevel->menuId) as $thirdlevel)
																		<li class="dd-item tile" data-id="{!! $thirdlevel->menuId !!}">
																			<div class="dd-handle btn btn-default-light">{!! Adminmenumanage::getmenuname($thirdlevel->menuId)!!}</div>
																			</li>
																		@endforeach
																	</ol>
																	@else
																	</li>
																	@endif


																@endforeach
															</ol>
															@else
															</li>
															@endif
														@endforeach
														@endif
														</ol>
													</div><!--end .dd.nestable-list -->
													<div class="section-header pull-right buttonDiv" style="display:none;">
														<a href="javascript:void(0)" class="btn saveMenu ink-reaction btn-block btn-primary-dark">Save Menu</a>
													</div>
											</div><!--end .col -->
										</div><!--end .row -->
									</div><!--end .card-body -->
								</div><!--end .card -->
							</div><!--end .col -->
						</div><!--end .row -->
						<!-- END NESTABLE LISTS -->

					</div><!--end .section-body -->
				</section>
			</div><!--end #content-->
			<!-- END CONTENT -->

			<input type="hidden" id="nestable-output">

			@stop

@section('script')
{!!HTML::script('backend/assets/js/libs/nestable/jquery.nestable.js')!!}
{!!HTML::script('backend/assets/js/core/demo/DemoUILists.js')!!}
{!!HTML::script('backend/js/adminmenu.js')!!}
<script type="text/javascript">
	$(document).ready(function(){
		var list=$('.menuList li').length;
		if(list==0){
			$('.buttonDiv').hide();
		}else{
			$('.buttonDiv').show();
		}

		$('.nestable-list').nestable({
        group: 1
    })
    .on('change', updateOutput);

    updateOutput($('.nestable-list').data('output', $('#nestable-output')));

    var checkedLen=$('#menuForm :input:checked').length;
    var totalLen=$('#menuForm :input').length;
    if(checkedLen==totalLen){
    	$('.selectAllMenu').prop('checked',true);
    }
	});	

	$(document).on('click','.selectAllMenu',function(){
		if($(this).is(':checked')){
			$('#menuForm :input').each(function(){
				var name=$(this).attr('data-menuName');
    			var id=$(this).attr('data-menuId');
				var liHtml='<li class="dd-item tile" data-id="'+id+'"><div class="dd-handle btn btn-default-light">'+name+'</div></li>';
	      		$('.menuList').append(liHtml);
	      		$(this).prop('checked',true);
			});
			$('.buttonDiv').show();
		}else{
			$('#menuForm :input').prop('checked',false);
			$('.menuList li').remove();
			$('.buttonDiv').hide();
		}
	});
</script>
@stop