<?php 
	use App\Models\User; 
	use App\Models\Generalsetting; 
	use App\Models\Adminmenu;
	use App\Models\Adminmenumanage;
?>
@extends("backend/master")
@section('maincontent')
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css')!!}
@stop
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li> <li class="active">Admin Menu</li>  <li class="active">Add</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Admin Menus</h1>
					</div><!--end .col -->

				<div class="col-md-4">
					<!-- ****************** FORM START HERE ***************** -->
					<form class="form" id="addmenuform">
							<div class="card">
								<div class="card-head style-primary">
									<header>Add New Admin Menu</header>
								</div>
								<div class="card-body">

									<div class="form-group">
										<input type="text" class="form-control" id="menuname" name="menuname">
										<label for="menuname">Menu Name</label>
										<p class="help-block">The name is how it appears on your site.</p>
									</div>
									<input type="hidden" name="_token" content="{!! app('Illuminate\Encryption\Encrypter')->encrypt(csrf_token()) !!}" />


									<div class="form-group">
										<select class="form-control" name="menutype" id="menutype">
										<option value="">Menu Location</option>
										<option value="sidebar">Left Sidebar</option>
										<option value="topbar">Top Menu</option>
										</select>
										<label for="menutype">Menu Type</label>
									</div>

									<div class="form-group">
										<input type="text" class="form-control" id="menuurl" name="menuurl" placeholder="http://www.example.com">
										<label for="menuurl">Menu URL</label>
										<p class="help-block">type without domain name</p>
									</div>

									<div class="form-group">
										<input type="text" class="form-control" id="menuicon" name="menuicon" placeholder="">
										<label for="menuurl">Font awesome Icon</label>
										<p class="help-block">font awesome icon text</p>
									</div>

								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" id="addmenu" class="btn ink-reaction btn-primary-dark">Save</button>&nbsp;&nbsp;
										<button type="reset" id="resetmenu" class="btn ink-reaction btn-info-dark">Reset</button>
									</div>
								</div>
							</div><!--end .card -->
					</form>
						<!-- ****************** FORM START HERE ***************** -->

						<div class="section-header">
							<a href="{!! URL::to('admin/settings/adminmenu/manage') !!}" class="btn ink-reaction btn-block btn-primary">Arrange Admin Menu Order</a>
						</div>
				</div><!--end .col -->

						

				<div class="col-md-8">
				<div class="card">
					<div class="card-head style-primary">
						<header>List of Admin Menu</header>
					</div>
					<div class="card-body">
					<div class="table-responsive">
					@if(count($menutable)>0)
						<table id="categorytable" class="table table-striped table-hover">
							<thead>
								<tr>
									<th>Name</th>
									<th>Status</th>
									<th>Edit</th>
									<th>Delete</th>
								</tr>
							</thead>
							<tbody id="menutablebox">
							@foreach($menutable as $menu)
							<?php
							if($menu->status=='active'){
								$class='btn-primary';
							}else{
								$class='btn-danger';
							}
							?>
							<tr>
								<td>{!! $menu->menuname !!}</td>
								<td><a href="javascript:void(0);" class="btn btn-xs {!! $class !!} menustatus" data-id="{!! $menu->id !!}">{!! ucfirst($menu->status) !!} </a></td>
						<td><a href="javascript:void(0)" class="btn btn-xs btn-primary menuedit"  data-id="{!! $menu->id !!}"><i class="fa fa-edit"></i> Edit </a></td>
						<td><button type="button" class="btn btn-icon-toggle ink-reaction adminmenuDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="{!! $menu->id !!}"><i class="fa fa-trash-o"></i></button></td>
					</tr>
					@endforeach
							</tbody>
						</table>
					@else
					No Menu available.
					@endif
					</div><!--end .table-responsive -->
					</div><!--end card-body-->
				</div>
				</div><!--end .col -->

				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop
@section('script')
{!!HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js')!!}
{!!HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js')!!}
{!!HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js')!!}
{!!HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js')!!}
{!!HTML::script('backend/js/adminmenu.js')!!}
@stop