<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Generalsetting; 
?>
@extends("backend/master")
@section("styles")
{!!HTML::style('backend/assets/css/theme-default/libs/dropzone/dropzone-theme.css')!!}
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Tools</li>
					<li class="active">Designs</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Designs</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
					</div><!--end .col -->
					<div class="col-md-8">
								<div class="card">
									<div class="card-body">
										<ul class="nav nav-tabs" data-toggle="tabs">
											<li class="active"><a href="#headerDesigns">Header</a></li>
											<li class=""><a href="#footerDesigns">Footer</a></li>
											<li class=""><a href="#third8">THE THIRD</a></li>
										</ul>
										<br>
										<div class="tab-content">
											<div class="tab-pane active" id="headerDesigns">
												{!! Form::open(["url"=>"admin/tools/designs","class"=>"form"]) !!}
												<div class="form-group floating-label @if($errors->has('logo'))has-error @endif">
													{!! Form::text("logo",Option::getvalue("logo"),["class"=>"form-control"]) !!}
														@if($errors->has("logo"))
															<span class="text-danger">{!! $errors->first("logo") !!}</span>
														@endif
													{!! HTML::decode(Form::label("logo","Logo")) !!}
												</div>
												<em class="text-caption">(will be displayed on website header and all email templates)</em>

												<div class="clearfix"></div>
												<div class="card-head style-primary">
													<header>Drag and drop uploader</header>
												</div>
												<div class="dropzone" id="dropzoneFileUpload">
        										</div>

												<div class="form-group col-md-2">
													<button type="button" class="btn btn-block ink-reaction btn-primary">Upload</button>
												</div>

												<div class="clearfix"></div>

												
												<h3>Contact Details</h3>
												<hr>
												<div class="form-group floating-label @if($errors->has('contactEmail'))has-error @endif">
													{!! Form::text("contactEmail",Option::getvalue("contactEmail"),["class"=>"form-control"]) !!}
														@if($errors->has("contactEmail"))
															<span class="text-danger">{!! $errors->first("contactEmail") !!}</span>
														@endif
													{!! HTML::decode(Form::label("contactEmail","Contact Email")) !!}
													<em class="text-caption">(will be displayed on website header and all email templates)</em>
												</div>

												<div class="form-group floating-label @if($errors->has('needHelp'))has-error @endif">
													{!! Form::text("needHelp",Option::getvalue("needHelp"),["class"=>"form-control"]) !!}
														@if($errors->has("needHelp"))
															<span class="text-danger">{!! $errors->first("needHelp") !!}</span>
														@endif
													{!! HTML::decode(Form::label("needHelp","Need Help?")) !!}
													<em class="text-caption">(will be displayed on website header and all email templates)</em>
												</div>


												<div class="card-actionbar">
													<div class="card-actionbar-row">
														{!! Form::submit("Save Settings",["class"=>"btn btn-flat btn-primary ink-reaction"]) !!}
														{!! Form::close() !!}
													</div>
												</div>
											</div>

											<div class="tab-pane" id="footerDesigns">
												{!! Form::open(["url"=>"admin/tools/designs","class"=>"form"]) !!}
												<div class="form-group floating-label @if($errors->has('copyright'))has-error @endif">
													{!! Form::text("copyright",Option::getvalue("copyright"),["class"=>"form-control"]) !!}
														@if($errors->has("copyright"))
															<span class="text-danger">{!! $errors->first("copyright") !!}</span>
														@endif
													{!! HTML::decode(Form::label("copyright","Copyright")) !!}
													<em class="text-caption">(will be displayed on website header and all email templates)</em>
												</div>

												<h3>Social Profiles</h3>
												<hr>

												<div class="form-group floating-label @if($errors->has('facebook'))has-error @endif">
													{!! Form::text("facebook",Option::getvalue("facebook"),["class"=>"form-control"]) !!}
														@if($errors->has("facebook"))
															<span class="text-danger">{!! $errors->first("facebook") !!}</span>
														@endif
													{!! HTML::decode(Form::label("facebook","Facebook")) !!}
												</div>

												<div class="form-group floating-label @if($errors->has('twitter'))has-error @endif">
													{!! Form::text("twitter",Option::getvalue("twitter"),["class"=>"form-control"]) !!}
														@if($errors->has("twitter"))
															<span class="text-danger">{!! $errors->first("twitter") !!}</span>
														@endif
													{!! HTML::decode(Form::label("twitter","Twitter")) !!}
												</div>

												<div class="form-group floating-label @if($errors->has('googlePlus'))has-error @endif">
													{!! Form::text("googlePlus",Option::getvalue("googlePlus"),["class"=>"form-control"]) !!}
														@if($errors->has("googlePlus"))
															<span class="text-danger">{!! $errors->first("googlePlus") !!}</span>
														@endif
													{!! HTML::decode(Form::label("googlePlus","Google +")) !!}
												</div>

												<div class="form-group floating-label @if($errors->has('linkedin'))has-error @endif">
													{!! Form::text("linkedin",Option::getvalue("linkedin"),["class"=>"form-control"]) !!}
														@if($errors->has("linkedin"))
															<span class="text-danger">{!! $errors->first("linkedin") !!}</span>
														@endif
													{!! HTML::decode(Form::label("linkedin","Linkedin")) !!}
												</div>

												<div class="form-group floating-label @if($errors->has('pinterest'))has-error @endif">
													{!! Form::text("pinterest",Option::getvalue("pinterest"),["class"=>"form-control"]) !!}
														@if($errors->has("pinterest"))
															<span class="text-danger">{!! $errors->first("pinterest") !!}</span>
														@endif
													{!! HTML::decode(Form::label("pinterest","Pinterest")) !!}
												</div>

												<div class="card-actionbar">
													<div class="card-actionbar-row">
														{!! Form::submit("Save Settings",["class"=>"btn btn-flat btn-primary ink-reaction"]) !!}
														{!! Form::close() !!}
													</div>
												</div>

												<h3>Partners Logo</h3>
												<hr>

												<div class="clearfix"></div>

												<div class="form-group col-md-2">
													<button type="button" class="btn btn-block ink-reaction btn-primary">Upload</button>
												</div>

												<div class="clearfix"></div>

											</div>

											<div class="tab-pane " id="third8"><p>Duo semper accumsan ea, quidam convenire cum cu, oportere maiestatis incorrupte est eu. Soluta audiam timeam ius te, idque gubergren forensibus ad mel, persius urbanitas usu id. Civibus nostrum fabellas mea te, ne pri lucilius iudicabit. Ut cibo semper vituperatoribus vix, cum in error elitr. Vix molestiae intellegat omittantur an, nam cu modo ullum scriptorem.</p>
												<p>Quod option numquam vel in, et fuisset delicatissimi duo, qui ut animal noluisse erroribus. Ea eum veniam audire. Per at postea mediocritatem, vim numquam aliquid eu, in nam sale gubergren. Dicant vituperata consequuntur at sea, mazim commodo</p>
											</div>
										</div>
									</div><!--end .card-body -->
								</div><!--end .card -->
							</div><!-- end of row -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/js/bala.js')!!}
{!!HTML::script('backend/assets/js/libs/dropzone/dropzone.min.js')!!}
<script type="text/javascript">
        var baseUrl = "{{ url('/') }}";
        var token = "{{ Session::getToken() }}";
        Dropzone.autoDiscover = false;
        alert("working..");
        var myDropzone = new Dropzone("div#dropzoneFileUpload", {
            url: baseUrl + "/dropzone/uploadFiles",
            params: {
                _token: token
            }
        });
         alert("working..");
        Dropzone.options.myAwesomeDropzone = {
            paramName: "file", // The name that will be used to transfer the file
            maxFilesize: 2, // MB
            addRemoveLinks: true,
            accept: function(file, done) {
 				alert("accepted"); return false;
            },
        };
    </script>
@stop