<?php 
	use App\Models\Returnstatuses; 
	use App\Models\Option;
	use App\Models\Upload; 
	use App\Models\Emailtemplates; 
?>
@extends("backend/master")
@section("styles")
	{!!HTML::style('backend/assets/css/theme-default/libs/summernote/summernote.css')!!} 
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Settings</li>
					<li class="active">Email Templates</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Email Templates</h1>
					</div><!--end .col -->
					<div class="col-md-3">
						<div class="card">
						<div class="card-body no-padding">
							<ul class="list">
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-dashboard"></i>
									</a>
									<a href="{{URL::to('admin/settings/store/product')}}" class="tile-content ink-reaction">
										<div class="tile-text">General Options</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-credit-card"></i>
									</a>
									<a href="{{URL::to('admin/settings/store/currency')}}" class="tile-content ink-reaction">
										<div class="tile-text">Currency Options</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-add-shopping-cart"></i>
									</a>
									<a href="{{ URL::to('admin/settings/store/checkout') }}" class="tile-content ink-reaction">
										<div class="tile-text">Checkout / Shipping</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction active">
										<i class="md md-email"></i>
									</a>
									<a href="javascript:void(0)" class="tile-content ink-reaction tile-active">
										<div class="tile-text">Email Templates</div>
									</a>
								</li>
							</ul>
						</div><!--end .card-body -->
						</div>
					</div><!--end .col -->
					<div class="col-md-6">
						<form class="form" id="headerform">
							<div class="card">
								<div class="card-head style-primary">
									<header>Email Template</header>
								</div>
								<div class="card-body">
									<div class="form-group @if($errors->has('type'))has-error @endif">
										{!! Form::select("type",[""=>"Select Template","admin"=>"New Admin Creation","purchase"=>"Order Confirmation","forgot"=>"Forgot Password","onlineUser"=>"Online User Creation","refere"=>"Refere a Friend","productAuthentication"=>"Product Authentication"],"",["class"=>"form-control","id"=>"templateType"]) !!}
											@if($errors->has("type"))
												<span id="type-error" class="help-block">{!! $errors->first("type") !!}</span>
											@endif
										{!! HTML::decode(Form::label("type","Templete<span class='text-danger'>*</span>")) !!}
									</div>

										<div class="templateHolder" style="display:none">
											<div class="form-group">
												<!--<input type="text" id="header_logo" name="header_logo" class="form-control" value="{{Upload::getimageurl(Option::getvalue('header_logo'))}}">-->
												<label for="uploadLogo">Upload Header</label>
												<p class="help-block">Please upload your Template Header.</p>
											</div><!--end form-group-->
											<p>
												<button class="btn ink-reaction btn-raised btn-sm btn-primary" id="headerlogobox" type="button">Upload</button> &nbsp;&nbsp;
												<button class="btn ink-reaction btn-raised btn-sm btn-default" id="header_removelogo" type="button">Remove</button>
												 <div class="progress progress-striped active" id="logoprogressbox" style="display:none;">
														<div class="progress-bar progress-bar-warning" id="logoprogress"></div>
												</div>
												<input type="file" id="headerlogo" style="display:none;">
											</p>

											<div class="row">
												<div class="col-md-3" id="logoplace">
													<img src="" id="logoplace" class="uploadedImage">
												</div>
											</div>
												<br>
										
									</div>

									<h4>Footer Content</h4>
										<div class="form-group">
											<p class="help-block">Footer is common for all templates</p>
									</div><!--end form-group-->

									<?php
										$regards = Emailtemplates::where("type","regards")->first();
										if($regards && $regards->image != "")
										{
											$regardsText = $regards->image;
										}
										else
										{
											$regardsText = "";
										}
									?>

									<div class="form-group">
										<input type="text" class="form-control" name="emailTemplateRegards" value="{!! $regardsText !!}" id="emailTemplateRegards">
										<label for="emailTemplateRegards">Regards</label>
									</div>

									<?php
										$footer = Emailtemplates::where("type","footerText")->first();
										if($footer && $footer->image != "")
										{
											$footerText = $footer->image;
										}
										else
										{
											$footerText = "";
										}
									?>

									<div class="form-group">
										<textarea placeholder="" rows="3" class="form-control" id="footerContent" name="footerContent">{!! $footerText !!}</textarea>
										<label for="footerContent">Footer Copyright</label>
										<p class="help-block">Please provide footer text which will be shown in footer</p>
									</div>

									

									
									<?php
										$twitter = Option::getvalue("social_twitterlink");
										$facebook = Option::getvalue("social_facebooklink");
										$google = Option::getvalue("social_googlepluslink");
										$pinterest = Option::getvalue("social_pinterestlink");
										$fooTwi = Emailtemplates::where("type","twitterStatus")->first();
										$fooFb = Emailtemplates::where("type","facebookStatus")->first();
										$fooGp = Emailtemplates::where("type","googleStatus")->first();
										$fooPt = Emailtemplates::where("type","pinterestStatus")->first();
										$colour = "";
										$status = "";
									?>
									@if($twitter!="")
										<?php 
											if($fooTwi==null || $fooTwi->image==""){
												$colour="danger";
												$status="inactive"; 
											}
											else{
												$status=$fooTwi->image;
												$status=="active"?$colour="success":$colour="danger";
											}
												
										?>
											<!--<div>
												<label class="col-md-2">Twitter</label>
												<label class="radio-inline radio-styled">
													<button type="button" class="btn btn-xs btn-{!! $colour !!} ink-reaction fooSettings" name="twitterStatus" value="">{!! ucfirst($status) !!}</button>
												</label>
											</div>-->
									@endif

									<div class="clearfix"></div>

									@if($facebook!="")
										<?php 
											if($fooFb==null || $fooTwi->image==""){
												$colour="danger";
												$status="inactive"; 
											}
											else{
												$status=$fooTwi->image;
												$status=="active"?$colour="success":$colour="danger";
											}
												
										?>
										<!-- <div>
											<label class="col-md-2">Facebook</label>
											<label class="radio-inline radio-styled">
												<button type="button" class="btn btn-xs btn-{!! $colour !!} ink-reaction fooSettings" name="facebookStatus" value="">{!! $status !!}</button>
											</label>
										</div> -->
									@endif

									<div class="clearfix"></div>

									@if($google!="")
										<?php 
											if($fooGp==null || $fooTwi->image==""){
												$colour="danger";
												$status="inactive"; 
											}
											else{
												$status=$fooTwi->image;
												$status=="active"?$colour="success":$colour="danger";
											}
												
										?>
										<!-- <div>
											<label class="col-md-2">Google+</label>
											<label class="radio-inline radio-styled">
												<button type="button" class="btn btn-xs btn-{!! $colour !!} ink-reaction fooSettings" name="googleStatus" value="">{!! $status !!}</button>
											</label>
										</div> -->
									@endif

									<div class="clearfix"></div>

									@if($pinterest!="")
										<?php 
											if($fooPt==null || $fooTwi->image==""){
												$colour="danger";
												$status="inactive"; 
											}
											else{
												$status=$fooTwi->image;
												$status=="active"?$colour="success":$colour="danger";
											}
												
										?>
										<!-- <div>
											<label class="col-md-2">Pinterest</label>
											<label class="radio-inline radio-styled">
												<button type="button" class="btn btn-xs btn-{!! $colour !!} ink-reaction fooSettings" name="pinterestStatus" value="">{!! $status !!}</button>
											</label>
										</div> -->
									@endif

									<div class="clearfix"></div>

									

								</div><!--end .card-body -->
								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" id="savefootersettings" class="btn ink-reaction btn-primary-dark">Save Changes</button>
									</div>
								</div>
							</div><!--end .card -->
						</form>
					</div><!-- end of col-md-8 -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!! HTML::script('backend/assets/js/libs/global/iframe-transport.js') !!}
{!! HTML::script('backend/assets/js/libs/global/jquery-ui.js') !!}
{!! HTML::script('backend/assets/js/libs/global/fileupload.js') !!}
{!! HTML::script('backend/assets/js/libs/summernote/summernote.min.js') !!} 
{!! HTML::script('backend/js/balaFileUpload.js') !!} 
<script type="text/javascript">
	//$("#footerContent").summernote();
	$(document).ready(function(){
		//var fc=$("#footerContent").val();
	});
</script>
@stop