<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Generalsetting; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Settings</li>
					<li class="active">General</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">General Settings</h1>
					</div><!--end .col -->

					<div class="col-md-12">
						<div class="card">
							<div class="card-head style-primary">
								<header>General Settings</header>
							</div>

							@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

							<div class="card-body">
								{!! Form::open(["url"=>"admin/settings/general","class"=>"form"]) !!}
									<div class="form-group @if($errors->has('siteTitle'))has-error @endif">
										{!! Form::text("siteTitle",Option::getvalue("siteTitle"),["class"=>"form-control"]) !!}
											@if($errors->has("siteTitle"))
												<span id="siteTitle-error" class="help-block">{!! $errors->first("siteTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("siteTitle","Site Title<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('portalName'))has-error @endif">
										{!! Form::text("portalName",Option::getvalue("portalName"),["class"=>"form-control"]) !!}
											@if($errors->has("portalName"))
												<span id="portalName-error" class="help-block">{!! $errors->first("portalName") !!}</span>
											@endif
										{!! HTML::decode(Form::label("portalName","Portal Name<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('emailNotification'))has-error @endif">
										{!! Form::text("emailNotification",Option::getvalue("emailNotification"),["class"=>"form-control"]) !!}
											@if($errors->has("emailNotification"))
												<span id="emailNotification-error" class="help-block">{!! $errors->first("emailNotification") !!}</span>
											@endif
										{!! HTML::decode(Form::label("emailNotification","E-Mail Notification<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('smsNotification'))has-error @endif">
										{!! Form::text("smsNotification",Option::getvalue("smsNotification"),["class"=>"form-control"]) !!}
											@if($errors->has("smsNotification"))
												<span id="smsNotification-error" class="help-block">{!! $errors->first("smsNotification") !!}</span>
											@endif
										{!! HTML::decode(Form::label("smsNotification","SMS Notification<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('homeUrl'))has-error @endif">
										{!! Form::text("homeUrl",Option::getvalue("homeUrl"),["class"=>"form-control"]) !!}
											@if($errors->has("homeUrl"))
												<span id="homeUrl-error" class="help-block">{!! $errors->first("homeUrl") !!}</span>
											@endif
										{!! HTML::decode(Form::label("homeUrl","Home URL<span class='text-danger'>*</span>")) !!}
									</div>

									<div>
										<?php $dateFormat=Option::getvalue("dateFormat"); ?>
										<label>Date Format<span class='text-danger'>*</span></label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="d S F Y" <?php if($dateFormat=="d S F Y"){ echo "checked";} ?>><span>{!! date("dS F Y") !!}</span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="Y-m-d" <?php if($dateFormat=="Y-m-d"){ echo "checked";} ?>><span>{!! date("Y-m-d") !!}</span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="m/d/Y" <?php if($dateFormat=="m/d/y"){ echo "checked";} ?>><span>{!! date("m/d/Y") !!}</span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="d/m/Y" <?php if($dateFormat=="d/m/Y"){ echo "checked";} ?>><span>{!! date("d/m/Y") !!}</span><br>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="D, d-M-Y" <?php if($dateFormat=="D, d-M-Y"){ echo "checked";} ?>><span>{!! date("D, d-M-Y") !!}</span><br>
										</label><br>
										<span id="dateFormat-error" class="help-block">{!! $errors->first("dateFormat") !!}</span>
									</div>

									<div>
										<?php $timeFormat=Option::getvalue("timeFormat"); ?>
										<label>Time Format<span class='text-danger'>*</span></label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="timeFormat" value="h:i a" <?php if($timeFormat=="h:i a"){ echo "checked";} ?>><span>{!! date("h:i a") !!}</span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="timeFormat" value="h:i A" <?php if($timeFormat=="h:i A"){ echo "checked";} ?>><span>{!! date("h:i A") !!}</span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="timeFormat" value="h:i" <?php if($timeFormat=="h:i"){ echo "checked";} ?>><span>{!! date("h:i") !!}</span>
										</label>
										<span id="timeFormat-error" class="help-block">{!! $errors->first("timeFormat") !!}</span>
									</div>

									<div class="form-group @if($errors->has('corporate'))has-error @endif">
										{!! Form::text("corporate", Option::getvalue("corporate"), ["class"=>"form-control"]) !!}
											@if($errors->has("corporate"))
												<span id="corporate-error" class="help-block">{!! $errors->first("corporate") !!}</span>
											@endif
										{!! HTML::decode(Form::label("corporate","Corporate Price<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('individual'))has-error @endif">
										{!! Form::text("individual", Option::getvalue("individual"), ["class"=>"form-control"]) !!}
											@if($errors->has("individual"))
												<span id="individual-error" class="help-block">{!! $errors->first("individual") !!}</span>
											@endif
										{!! HTML::decode(Form::label("individual","Individual Price<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('student'))has-error @endif">
										{!! Form::text("student", Option::getvalue("student"), ["class"=>"form-control"]) !!}
											@if($errors->has("student"))
												<span id="student-error" class="help-block">{!! $errors->first("student") !!}</span>
											@endif
										{!! HTML::decode(Form::label("student","Student Price<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('courseFee'))has-error @endif">
										{!! Form::text("courseFee", Option::getvalue("courseFee"), ["class"=>"form-control"]) !!}
											@if($errors->has("courseFee"))
												<span id="courseFee-error" class="help-block">{!! $errors->first("courseFee") !!}</span>
											@endif
										{!! HTML::decode(Form::label("courseFee","Course Fee<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('GST'))has-error @endif">
										{!! Form::text("GST", Option::getvalue("GST"), ["class"=>"form-control"]) !!}
										<em>Enter Only Percentage value Ex: 18</em>
											@if($errors->has("GST"))
												<span id="GST-error" class="help-block">{!! $errors->first("GST") !!}</span>
											@endif
										{!! HTML::decode(Form::label("GST","GST<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="card-actionbar">
										<div class="card-actionbar-row">
											<button type="submit" class="btn ink-reaction btn-primary-dark">Save Settings</button>
											{!! Form::close() !!}
										</div>
									</div>
								{!! Form::close() !!}
							</div><!--end .card-body -->
						</div><!--end .card -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	<script>
		$('input[name="GST"]').keyup(function() {
	        if (this.value.match(/[^0-9 ]/g)) {
	            this.value = this.value.replace(/[^0-9 ]/g, '');
	        }
	    });
	</script>
@stop