<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Generalsetting; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i>Home</li>
					<li class="active">Settings</li>
					<li class="active">Mail</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Mail Settings</h1>
					</div><!--end .col -->

					<div class="col-md-12">
						<div class="card">
							<div class="card-head style-primary">
								<header>Mail Settings</header>
							</div>

							@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

							<div class="card-body">
								{!! Form::open(["url"=>"admin/settings/general","class"=>"form"]) !!}
									<div class="form-group @if($errors->has('senderEmail'))has-error @endif">
										{!! Form::text("senderEmail",Option::getvalue("senderEmail"),["class"=>"form-control"]) !!}
											@if($errors->has("senderEmail"))
												<span id="senderEmail-error" class="help-block">{!! $errors->first("senderEmail") !!}</span>
											@endif
										{!! HTML::decode(Form::label("senderEmail","Sender Email<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('senderName'))has-error @endif">
										{!! Form::text("senderName",Option::getvalue("senderName"),["class"=>"form-control"]) !!}
											@if($errors->has("senderName"))
												<span id="senderName-error" class="help-block">{!! $errors->first("senderName") !!}</span>
											@endif
										{!! HTML::decode(Form::label("senderName","Sender Name<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('smtpHost'))has-error @endif">
										{!! Form::text("smtpHost",Option::getvalue("smtpHost"),["class"=>"form-control"]) !!}
											@if($errors->has("smtpHost"))
												<span id="smtpHost-error" class="help-block">{!! $errors->first("smtpHost") !!}</span>
											@endif
										{!! HTML::decode(Form::label("smtpHost","SMTP Host<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('smtpPort'))has-error @endif">
										{!! Form::text("smtpPort",Option::getvalue("smtpPort"),["class"=>"form-control"]) !!}
											@if($errors->has("smtpPort"))
												<span id="smtpPort-error" class="help-block">{!! $errors->first("smtpPort") !!}</span>
											@endif
										{!! HTML::decode(Form::label("smtpPort","SMTP Port<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('smtpEmail'))has-error @endif">
										{!! Form::text("smtpEmail",Option::getvalue("smtpEmail"),["class"=>"form-control"]) !!}
											@if($errors->has("smtpEmail"))
												<span id="smtpEmail-error" class="help-block">{!! $errors->first("smtpEmail") !!}</span>
											@endif
										{!! HTML::decode(Form::label("smtpEmail","SMTP Email<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('smtpPassword'))has-error @endif">
										{!! Form::text("smtpPassword",Option::getvalue("smtpPassword"),["class"=>"form-control"]) !!}
											@if($errors->has("smtpPassword"))
												<span id="smtpPassword-error" class="help-block">{!! $errors->first("smtpPassword") !!}</span>
											@endif
										{!! HTML::decode(Form::label("smtpPassword","SMTP Password<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="card-actionbar">
										<div class="card-actionbar-row">
											{!! Form::submit("Save Settings",["class"=>"btn ink-reaction btn-primary-dark"]) !!}
											{!! Form::close() !!}
										</div>
									</div>
							    {!! Form::close() !!}
							</div><!--end .card-body -->
						</div><!--end .card -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary"></h1>
					</div><!--end .col -->

					<div class="col-md-12">
						{!! Form::open(["url"=>"admin/settings/mail/testing","class"=>"form"]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Test Mail</header>
								</div>
								
								<div class="card-body">
									<p>
										Send a test message.
										The message will be sent from the current store administrator address with a Subject of '{!! Option::getvalue("portalName") !!} Test Mail' and the current settings in the message body.
									</p>

									<div class="form-group @if($errors->has('testEmail'))has-error @endif">
										{!! Form::text("testEmail",Option::getvalue("testEmail"),["class"=>"form-control"]) !!}
											@if($errors->has("testEmail"))
												<span id="testEmail-error" class="help-block">{!! $errors->first("testEmail") !!}</span>
											@endif
										{!! HTML::decode(Form::label("testEmail","Test Email Address<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="card-actionbar">
										<div class="card-actionbar-row">
											{!! Form::submit("Send Mail",["class"=>"btn ink-reaction btn-primary-dark"]) !!}
										</div>
									</div>
								</div><!--end .card-body -->
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
@stop