<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Generalsetting; 
	use App\Models\CustomPages;
	//use App\Models\Productdetails;
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Settings</li>
					<li class="active">Popup</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-md-12">

						@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

						{!! Form::open(["url"=>"admin/settings/popup/banner/post","class"=>"form","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Home Page Popup</header>
								</div>

								<div class="card-body">
									<div class="row">
										<div class="col-md-5">
											<div class="form-group @if($errors->has('currentBannerImg'))has-error @endif">
												{!! HTML::decode(Form::label("currentBannerImg","Current Banner Image <span class='text-danger'></span>")) !!}<br>
												{!! HTML::image(CustomPages::getcontent("popUpBannerImg"),'',["class"=>"featuredImage img-responsive"]) !!}
											</div><!--end form-group-->
										</div>
										<div class="col-md-7">
											<div class="form-group @if($errors->has('popUpBannerImg'))has-error @endif">
												{!! HTML::decode(Form::label("popUpBannerImg","Upload Banner Image <span class='text-danger'></span>")) !!}<br>
												@if($errors->has("popUpBannerImg"))
													<span id="popUpBannerImg-error" class="help-block">{!! $errors->first("popUpBannerImg") !!}</span>
												@endif
												{!! Form::file("popUpBannerImg",["class"=>"form-control"]) !!}
												<p class="help-block">Recommended Resolution 700px x 450px</p>
											</div><!--end form-group-->


											<div class="form-group">
											<div class="checkbox checkbox-styled">
												<label>
													{!! Form::checkbox("popUpEnable","yes",CustomPages::getcontent("popUpEnable") == "yes",["id"=>"popUpEnable"]) !!}
													<span>Enable Popup</span>
												</label>
											</div>
											</div>

											<div class="form-group">
												<div class="checkbox checkbox-styled">
													<label>
														{!! Form::checkbox("manualPopUpClose","yes",CustomPages::getcontent("manualPopUpClose") == "yes",["id"=>"manualPopUpClose"]) !!}
														<span>Manual Popup Close</span>
													</label>
												</div>
											</div>

											<div class="form-group">
												<div class="checkbox checkbox-styled">
													<label>
														{!! Form::checkbox("enablePopUpCookie","yes",CustomPages::getcontent("enablePopUpCookie") == "yes",["id"=>"enablePopUpCookie"]) !!}
														<span>Enable Cookie</span>
													</label>
												</div>
											</div>

											<div class="form-group @if($errors->has('popUpCookieExpire')) has-error @endif popUpCookieExpireDiv" style="display:none">
												{!! Form::text("popUpCookieExpire",CustomPages::getcontent("popUpCookieExpire"),["class"=>"form-control","placeholder"=>"Popup Cookie Expire"]) !!}
												@if($errors->has("popUpCookieExpire"))
													<span id="popUpCookieExpire-error" class="help-block">{!! $errors->first("popUpCookieExpire") !!}</span>
												@endif
												{!! HTML::decode(Form::label("popUpCookieExpire","Popup Cookie Expire <span class='text-danger'>*</span>")) !!}
											</div><!--end form-group-->

											<div class="form-group @if($errors->has('popUpDelayInterval'))has-error @endif">
												{!! Form::text("popUpDelayInterval",CustomPages::getcontent("popUpDelayInterval"),["class"=>"form-control","placeholder"=>"Popup Delay Interval"]) !!}
												@if($errors->has("popUpDelayInterval"))
													<span id="popUpDelayInterval-error" class="help-block">{!! $errors->first("popUpDelayInterval") !!}</span>
												@endif
												{!! HTML::decode(Form::label("popUpDelayInterval","Popup Delay Interval <span class='text-danger'>*</span>")) !!}
											</div><!--end form-group-->

											<div class="form-group">
												<div class="checkbox checkbox-styled">
													<label>
														{!! Form::checkbox("popupAllProducts","yes",CustomPages::getcontent("popupAllProducts") == "yes",["id"=>"popupAllProducts"]) !!}
														<span>Link To All Products</span>
													</label>
												</div>
											</div>

											<?php
												$products = [];//Productdetails::where("productstatus", "online")->pluck("productname", "id");
											?>

											<div id="linkPopupProductsDiv" class="form-group @if($errors->has('linkPopupProducts'))has-error @endif">
												{!! Form::select("linkPopupProducts",$products,CustomPages::getcontent("linkPopupProducts"),["class"=>"form-control","id"=>"linkPopupProducts","placeholder"=>"Select Product To Link"]) !!}
												@if($errors->has("linkPopupProducts"))
													<span id="linkPopupProducts-error" class="help-block">{!! $errors->first("linkPopupProducts") !!}</span>
												@endif
												{!! HTML::decode(Form::label("linkPopupProducts","Products<span class='text-danger'>*</span>")) !!}
											</div>
										</div>
									</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" id="postPopupBannerButton" class="btn ink-reaction btn-primary-dark">Save Settings</button>
									</div>
								</div>
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->


				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-md-12">
						{!! Form::open(["url"=>"admin/settings/diet/popup/banner/post","class"=>"form","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Home Page Diet Plan Popup</header>
								</div>

								<div class="card-body">
									<div class="row">
										<div class="col-md-5">
											<div class="form-group @if($errors->has('currentDietPlanBannerImg'))has-error @endif">
												{!! HTML::decode(Form::label("currentDietPlanBannerImg", "Current Banner Image <span class='text-danger'></span>")) !!}<br>
												{!! HTML::image(CustomPages::getcontent("popUpDietBannerImg"),'',["class"=>"featuredImage img-responsive"]) !!}
											</div><!--end form-group-->
										</div>

										<div class="col-md-7">
											<div class="form-group @if($errors->has('popUpDietBannerImg'))has-error @endif">
												{!! HTML::decode(Form::label("popUpDietBannerImg","Upload Banner Image <span class='text-danger'></span>")) !!}<br>
												@if($errors->has("popUpDietBannerImg"))
													<span id="popUpDietBannerImg-error" class="help-block">{!! $errors->first("popUpDietBannerImg") !!}</span>
												@endif
												{!! Form::file("popUpDietBannerImg",["class"=>"form-control"]) !!}
												<p class="help-block">Recommended Resolution 700px x 450px</p>
											</div><!--end form-group-->


											<div class="form-group">
											<div class="checkbox checkbox-styled">
												<label>
													{!! Form::checkbox("popUpDietEnable","yes",CustomPages::getcontent("popUpDietEnable") == "yes",["id"=>"popUpDietEnable"]) !!}
													<span>Enable Popup</span>
												</label>
											</div>
											</div>

											<div class="form-group">
												<div class="checkbox checkbox-styled">
													<label>
														{!! Form::checkbox("manualPopUpDietClose","yes",CustomPages::getcontent("manualPopUpDietClose") == "yes",["id"=>"manualPopUpDietClose"]) !!}
														<span>Manual Popup Close</span>
													</label>
												</div>
											</div>

											<div class="form-group">
												<div class="checkbox checkbox-styled">
													<label>
														{!! Form::checkbox("enablePopUpDietCookie","yes",CustomPages::getcontent("enablePopUpDietCookie") == "yes",["id"=>"enablePopUpDietCookie"]) !!}
														<span>Enable Cookie</span>
													</label>
												</div>
											</div>

											<div class="form-group @if($errors->has('popUpDietCookieExpire')) has-error @endif popUpDietCookieExpireDiv" style="display:none">
												{!! Form::text("popUpDietCookieExpire",CustomPages::getcontent("popUpDietCookieExpire"),["class"=>"form-control","placeholder"=>"Popup Cookie Expire"]) !!}
												@if($errors->has("popUpDietCookieExpire"))
													<span id="popUpDietCookieExpire-error" class="help-block">{!! $errors->first("popUpDietCookieExpire") !!}</span>
												@endif
												{!! HTML::decode(Form::label("popUpDietCookieExpire","Popup Cookie Expire <span class='text-danger'>*</span>")) !!}
											</div><!--end form-group-->

											<div class="form-group @if($errors->has('popUpDietDelayInterval'))has-error @endif">
												{!! Form::text("popUpDietDelayInterval",CustomPages::getcontent("popUpDietDelayInterval"),["class"=>"form-control","placeholder"=>"Popup Delay Interval"]) !!}
												@if($errors->has("popUpDietDelayInterval"))
													<span id="popUpDietDelayInterval-error" class="help-block">{!! $errors->first("popUpDietDelayInterval") !!}</span>
												@endif
												{!! HTML::decode(Form::label("popUpDietDelayInterval","Popup Delay Interval <span class='text-danger'>*</span>")) !!}
											</div><!--end form-group-->
										</div>

										<div class="clearfix"></div>

										<div class="col-md-3">
											<div class="checkbox checkbox-styled">
												<label>
													{!! Form::checkbox("dietPlanOneStatus", "active", CustomPages::getcontent("dietPlanOneStatus") == "active",["id"=>"dietPlanOneStatus"]) !!}
													<span>Enable Diet Plan One</span>
												</label>
											</div>

											<div id="dietPlanOneDiv" class="form-group @if($errors->has('dietPlanOneName'))has-error @endif" style="display:none">
												{!! Form::text("dietPlanOneName", CustomPages::getcontent("dietPlanOneName"),["class"=>"form-control", "placeholder"=>"Diet Plan One Name"]) !!}
												@if($errors->has("dietPlanOneName"))
													<span id="dietPlanOneName-error" class="help-block">{!! $errors->first("dietPlanOneName") !!}</span>
												@endif
												{!! HTML::decode(Form::label("dietPlanOneName", "Label Name <span class='text-danger'></span>")) !!}
											</div><!--end form-group-->
										</div>

										<div class="col-md-3">
											<div class="checkbox checkbox-styled">
												<label>
													{!! Form::checkbox("dietPlanTwoStatus", "active", CustomPages::getcontent("dietPlanTwoStatus") == "active",["id"=>"dietPlanTwoStatus"]) !!}
													<span>Enable Diet Plan Two</span>
												</label>
											</div>

											<div id="dietPlanTwoDiv" class="form-group @if($errors->has('dietPlanTwoName'))has-error @endif" style="display:none">
												{!! Form::text("dietPlanTwoName", CustomPages::getcontent("dietPlanTwoName"),["class"=>"form-control", "placeholder"=>"Diet Plan Two Name"]) !!}
												@if($errors->has("dietPlanTwoName"))
													<span id="dietPlanTwoName-error" class="help-block">{!! $errors->first("dietPlanTwoName") !!}</span>
												@endif
												{!! HTML::decode(Form::label("dietPlanTwoName", "Label Name <span class='text-danger'></span>")) !!}
											</div><!--end form-group-->
										</div>

										<div class="col-md-3">
											<div class="checkbox checkbox-styled">
												<label>
													{!! Form::checkbox("dietPlanThreeStatus", "active", CustomPages::getcontent("dietPlanThreeStatus") == "active",["id"=>"dietPlanThreeStatus"]) !!}
													<span>Enable Diet Plan Three</span>
												</label>
											</div>

											<div id="dietPlanThreeDiv" class="form-group @if($errors->has('dietPlanThreeName'))has-error @endif" style="display:none">
												{!! Form::text("dietPlanThreeName", CustomPages::getcontent("dietPlanThreeName"),["class"=>"form-control", "placeholder"=>"Diet Plan Three Name"]) !!}
												@if($errors->has("dietPlanThreeName"))
													<span id="dietPlanThreeName-error" class="help-block">{!! $errors->first("dietPlanThreeName") !!}</span>
												@endif
												{!! HTML::decode(Form::label("dietPlanThreeName", "Label Name <span class='text-danger'></span>")) !!}
											</div><!--end form-group-->
										</div>

										<div class="col-md-3">
											<div class="checkbox checkbox-styled">
												<label>
													{!! Form::checkbox("dietPlanFourStatus", "active", CustomPages::getcontent("dietPlanFourStatus") == "active",["id"=>"dietPlanFourStatus"]) !!}
													<span>Enable Diet Plan Four</span>
												</label>
											</div>

											<div id="dietPlanFourDiv" class="form-group @if($errors->has('dietPlanFourName'))has-error @endif" style="display:none">
												{!! Form::text("dietPlanFourName", CustomPages::getcontent("dietPlanFourName"),["class"=>"form-control", "placeholder"=>"Diet Plan Four Name"]) !!}
												@if($errors->has("dietPlanFourName"))
													<span id="dietPlanFourName-error" class="help-block">{!! $errors->first("dietPlanFourName") !!}</span>
												@endif
												{!! HTML::decode(Form::label("dietPlanFourName", "Label Name <span class='text-danger'></span>")) !!}
											</div><!--end form-group-->
										</div>
									</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" id="postPopupDietBannerButton" class="btn ink-reaction btn-primary-dark">Save Settings</button>
									</div>
								</div>
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->

			 <!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-md-12">
						{!! Form::open(["url"=>"admin/settings/popup/product/banner/post","class"=>"form","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Product Special Offers Popup</header>
								</div>
								<div class="card-body">

									<div class="row">
										
										<div class="col-md-7">

											<div class="form-group">
												<div class="checkbox checkbox-styled">
													<label>
														{!! Form::checkbox("manualPopUpProductClose","yes",CustomPages::getcontent("manualPopUpProductClose") == "yes",["id"=>"manualPopUpProductClose"]) !!}
														<span>Manual Popup Close</span>
													</label>
												</div>
											</div>

											<div class="form-group">
												<div class="checkbox checkbox-styled">
													<label>
														{!! Form::checkbox("enablePopUpProductCookie","yes",CustomPages::getcontent("enablePopUpProductCookie") == "yes",["id"=>"enablePopUpProductCookie"]) !!}
														<span>Enable Cookie</span>
													</label>
												</div>
											</div>

											<div class="form-group @if($errors->has('popUpProductCookieExpire')) has-error @endif popUpProductCookieExpireDiv" style="display:none">
												{!! Form::text("popUpProductCookieExpire",CustomPages::getcontent("popUpProductCookieExpire"),["class"=>"form-control","placeholder"=>"Popup Cookie Expire"]) !!}
												@if($errors->has("popUpProductCookieExpire"))
													<span id="popUpProductCookieExpire-error" class="help-block">{!! $errors->first("popUpProductCookieExpire") !!}</span>
												@endif
												{!! HTML::decode(Form::label("popUpProductCookieExpire","Popup Cookie Expire <span class='text-danger'>*</span>")) !!}
											</div><!--end form-group-->

											<div class="form-group @if($errors->has('popUpProductDelayInterval'))has-error @endif">
												{!! Form::text("popUpProductDelayInterval",CustomPages::getcontent("popUpProductDelayInterval"),["class"=>"form-control","placeholder"=>"Popup Delay Interval"]) !!}
												@if($errors->has("popUpProductDelayInterval"))
													<span id="popUpProductDelayInterval-error" class="help-block">{!! $errors->first("popUpProductDelayInterval") !!}</span>
												@endif
												{!! HTML::decode(Form::label("popUpProductDelayInterval","Popup Delay Interval <span class='text-danger'>*</span>")) !!}
											</div><!--end form-group-->
										</div>
									</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" id="postProductPopupBannerButton" class="btn ink-reaction btn-primary-dark">Save Settings</button>
									</div>
								</div>
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
@stop