<?php 
	use App\Models\Returnstatuses; 
	use App\Models\Option;
	use App\Models\Upload; 
	use App\Models\Currency;
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Tools</li>
					<li class="active">Settings</li>
					<li class="active">Store</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Store Settings</h1>
					</div><!--end .col -->
					<div class="col-md-3">
						<div class="card">
						<div class="card-body no-padding">
							<ul class="list">
								<li class="tile">
									<a class="btn btn-flat ink-reaction active">
										<i class="md md-dashboard"></i>
									</a>
									<a href="{{URL::to('admin/settings/store/product')}}" class="tile-content ink-reaction tile-active">
										<div class="tile-text">General Options</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-credit-card"></i>
									</a>
									<a href="{{URL::to('admin/settings/store/currency')}}" class="tile-content ink-reaction">
										<div class="tile-text">Currency Options</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-add-shopping-cart"></i>
									</a>
									<a href="{{ URL::to('admin/settings/store/checkout') }}" class="tile-content ink-reaction">
										<div class="tile-text">Checkout / Shipping</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-email"></i>
									</a>
									<a href="{!! URL::to('admin/settings/email/templates') !!}" class="tile-content ink-reaction">
										<div class="tile-text">Email Templates</div>
									</a>
								</li>
							</ul>
						</div><!--end .card-body -->
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						<form class="form" id="storeproductform">
						<div class="card">
							<div class="card-head style-primary">
								<header>General Options</header>
							</div>
							<div class="card-body">
								<h2 class="text-primary">Image Options</h2>
								<div class="row">
								<div class="col-md-12">								
									<div class="form-group">
										<label for="regular13">Catalog Images</label>
										<div class="col-sm-2">
											<input type="text" id="storeproduct_catalogimgwidth" name="storeproduct_catalogimgwidth" class="form-control" value="{{Option::getvalue('storeproduct_catalogimgwidth')}}"><div class="form-control-line"></div>
										</div>
										<div class="col-sm-1 text-center"><i class="fa fa-close"></i></div>
										<div class="col-sm-2">
											<input type="text" id="storeproduct_catalogimgheight" name="storeproduct_catalogimgheight" class="form-control" value="{{Option::getvalue('storeproduct_catalogimgheight')}}"><div class="form-control-line"></div>
										</div>
										<div class="col-sm-1 text-center">px</div>
									</div>
								</div>
								</div>

								<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<label for="regular13">Single Product Image</label>
										<div class="col-sm-2">
											<input type="text" id="storeproduct_productimgwidth" name="storeproduct_productimgwidth" class="form-control" value="{{Option::getvalue('storeproduct_productimgwidth')}}"><div class="form-control-line"></div>
										</div>
										<div class="col-sm-1 text-center"><i class="fa fa-close"></i></div>
										<div class="col-sm-2">
											<input type="text" id="storeproduct_productimgheight" name="storeproduct_productimgheight" class="form-control" value="{{Option::getvalue('storeproduct_productimgheight')}}"><div class="form-control-line"></div>
										</div>
										<div class="col-sm-1 text-center">px</div>
									</div>
								</div>
								</div>
								<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<label for="regular13">Thumbnail Image</label>
										<div class="col-sm-2">
											<input type="text" id="storeproduct_thumbnailimgwidth" name="storeproduct_thumbnailimgwidth" class="form-control" value="{{Option::getvalue('storeproduct_thumbnailimgwidth')}}"><div class="form-control-line"></div>
										</div>
										<div class="col-sm-1 text-center"><i class="fa fa-close"></i></div>
										<div class="col-sm-2">
											<input type="text" id="storeproduct_thumbnailimgheight" name="storeproduct_thumbnailimgheight" class="form-control" value="{{Option::getvalue('storeproduct_thumbnailimgheight')}}"><div class="form-control-line"></div>
										</div>
										<div class="col-sm-1 text-center">px</div>
									</div>
								</div>
								</div>
								<?php if(Option::getvalue('storeproduct_enablesms') == 'true'){ $check = 'checked'; }else{ $check = ''; } ?>
								<div class="form-group">
									<div class="checkbox checkbox-styled">
										<label>
											<input type="checkbox" id="storeproduct_enablesms" name="storeproduct_enablesms" value="true" <?php echo $check; ?>>
											<span> Enable SMS Gateway</span>
										</label>
									</div>
								</div><!--end form-group-->

								<?php if(Option::getvalue('storeproduct_enableRefereFriends') == 'true'){ $check = 'checked'; }else{ $check = ''; } ?>
								<div class="form-group">
									<div class="checkbox checkbox-styled">
										<label>
											<input type="checkbox" id="storeproduct_enableRefereFriends" name="storeproduct_enableRefereFriends" value="true" <?php echo $check; ?>>
											<span>Enable Refere a Friend</span>
										</label>
									</div>
								</div><!--end form-group-->

								<?php if(Option::getvalue('storeproduct_enableAccessories') == 'true'){ $check = 'checked'; }else{ $check = ''; } ?>
								<div class="form-group">
									<div class="checkbox checkbox-styled">
										<label>
											<input type="checkbox" id="storeproduct_enableAccessories" name="storeproduct_enableAccessories" value="true" <?php echo $check; ?>>
											<span>Enable Accessories</span>
										</label>
									</div>
								</div><!--end form-group-->
							</div><!--end .card-body -->
							<div class="card-actionbar">
								<div class="card-actionbar-row">
									<button type="submit" id="savestoreproduct" class="btn ink-reaction btn-primary-dark">Save Changes</button>
								</div>
							</div>
						</div><!--end .card -->
					</form>
					</div><!-- end of col-md-8 -->

				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!! HTML::script('backend/assets/js/libs/global/iframe-transport.js')  !!}
{!! HTML::script('backend/assets/js/libs/global/jquery-ui.js') !!}
{!! HTML::script('backend/assets/js/libs/global/fileupload.js') !!}
{!! HTML::script('backend/js/catalogfunction.js') !!} 
<script type="text/javascript">
</script>
@stop