<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Generalsetting; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Settings</li>
					<li class="active">System</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">System Settings</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
					</div><!--end .col -->
					<div class="col-md-9">
							<div class="card">
								<div class="card-head style-primary">
									<header>System Settings</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
										{!! Form::open(["url"=>"admin/settings/general","class"=>"form"]) !!}
												
												<div>
													<?php
														$errorPage=Option::getvalue("404error");
														$errorPage=="active"?$colour="success":$colour="danger";
													?>
													<label class="col-md-2">404 Page</label>
													<label class="radio-inline radio-styled">
														<button type="button" class="btn btn-xs btn-{!! $colour !!} ink-reaction systemSettings" name="404error" value="">{!! ucfirst($errorPage) !!}</button>
													</label>
												</div>

												<div class="clearfix"></div>

												<div>
													<?php
														$internal=Option::getvalue("500error");
														$internal=="active"?$colour="success":$colour="danger";
													?>
													<label class="col-md-2">Internal Server Page</label>
													<label class="radio-inline radio-styled">
														<button type="button" class="btn btn-xs btn-{!! $colour !!} ink-reaction systemSettings" name="500error" value="">{!! ucfirst($internal) !!}</button>
													</label>
												</div>

												<div class="clearfix"></div>

												<div>
													<?php
														$maintenance=Option::getvalue("underMaintenance");
														$maintenance=="active"?$colour="success":$colour="danger";
													?>
													<label class="col-md-2">Maintenance Mode </label>
													<label class="radio-inline radio-styled">
														<button type="button" class="btn btn-xs btn-{!! $colour !!} ink-reaction systemSettings" name="underMaintenance" value="" data-loading-text="processing...">{!! ucfirst($maintenance) !!}</button>
													</label>
												</div>

												<div class="clearfix"></div>

												<div>
													<?php
														$guest=Option::getvalue("guestLogin");
														$guest=="active"?$colour="success":$colour="danger";
													?>
													<label class="col-md-2">Guest Login </label>
													<label class="radio-inline radio-styled">
														<button type="button" class="btn btn-xs btn-{!! $colour !!} ink-reaction systemSettings" name="guestLogin" value="">{!! ucfirst($guest) !!}</button>
													</label>
												</div>

												<div class="clearfix"></div>

												<?php
													$breadCrumbs=Option::getvalue("breadCrumbs");
													$breadCrumbs=="active"?$colour="checked":$colour="";
												?>
												<div class="checkbox checkbox-styled">
													<label>
														<input type="checkbox" name="breadCrumbs" class="systemSettings" value="" {!! $colour !!}>
														<span>Enable Bread crumbs </span>
													</label>
												</div>
								</div><!--end .card-body -->
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/js/bala.js')!!}
@stop