@extends("backend/master")
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css')!!}
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Store Frontend</li>
					<li class="active">CMS</li>
					<li class="active">FAQ</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">CMS Pages</h1>
					</div><!--end .col -->
					<div class="col-md-3">
						<div class="card">
						<div class="card-body no-padding">
							<ul class="list">
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-dashboard"></i>
									</a>
									<a href="{{URL::to('admin/storefront/cms/about')}}" class="tile-content ink-reaction">
										<div class="tile-text">About</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-credit-card"></i>
									</a>
									<a href="{{URL::to('admin/storefront/cms/privacy')}}" class="tile-content ink-reaction">
										<div class="tile-text">Privacy Policy</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-local-mall"></i>
									</a>
									<a href="{{URL::to('admin/storefront/cms/terms')}}" class="tile-content ink-reaction">
										<div class="tile-text">Terms & Conditions</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction active">
										<i class="md md-filter-1"></i>
									</a>
									<a href="{{URL::to('admin/storefront/cms/faq')}}" class="tile-content ink-reaction tile-active">
										<div class="tile-text">FAQ</div>
									</a>
								</li>
							</ul>
						</div><!--end .card-body -->
						</div>
						<div class="section-header">
							<a href="{!! URL::to('admin/storefront/cms/faq/add') !!}" class="btn ink-reaction btn-block btn-primary">Add New FAQ</a>
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						<div class="card">
							<div class="card-head style-primary">
								<header>Manage FAQ</header>
							</div>
							@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
							<div class="card-body">
							<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Question</th>
										<th class="sort-numeric">Status</th>
										<th class="sort-alpha">Actions</th>
									</tr>
								</thead>
								<tbody>
									<?php $i=1; ?>
									@foreach($faqs as $faq)
										<tr class="gradeX">
											<td>{!! $i !!}</td>
											<td>{!! $faq->title !!}</td>
											<?php
												$faq->status=="active"?$class="success":$class="danger";
											?>
											<td><button type="button" class="btn ink-reaction btn-xs btn-{!! $class !!} faqStatus" data-id="{!! $faq->id !!}">{!! ucfirst($faq->status) !!}</button></td>
											<td>
											<a href="{!! URL::to('admin/storefront/cms/faq/modify/'.$faq->id) !!}">
											<button type="button" class="btn btn-icon-toggle ink-reaction" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
											</a>
											<button type="button" class="btn btn-icon-toggle ink-reaction faqDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="{!! $faq->id !!}"><i class="fa fa-trash-o"></i></button>
											</td>
										</tr>
									<?php $i++; ?>
									@endforeach
									
								</tbody>
							</table>
						</div><!--end .card-body -->
						</div>
						</div><!--end .card -->
						<em class="text-caption">Vertical layout with static labels</em>
					</div><!-- end of col-md-8 -->

				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js')!!}
{!!HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js')!!}
{!!HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js')!!}
{!!HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js')!!}
{!!HTML::script('backend/js/adminmenu.js')!!}
<script type="text/javascript">
	$(document).ready(function() {
	  $('#myTable').DataTable();
	});

	$(document).on("click",".faqStatus",function(){
		var clicked=$(this);
		var id=clicked.attr("data-id");
		// if(confirm("Do you really want to change this currency status?")==false){
		// 	return false;
		// }
		$.ajax({
			type: "POST",
			url: "/admin/storefront/cms/faq/status",
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
			data:{id},
			dataType: "json",
			success: function(data){
				console.log(data);
				var colour="";
				if(data.status=="success"){
					data.current=="Inactive"?colour="btn-danger":colour="btn-success";
					clicked.text(data.current);
					clicked.removeClass("btn-success btn-danger").addClass(colour);
					success_msg(data.msg);
				}
				return false;
			},
			error: function(e){
				console.log(e.responseText);
				return false;
			}
		});/* end of ajax function*/
	});/* end of click function */

	$(document).on("click",".faqDelete",function(){
		var clicked=$(this);
		var id=clicked.attr("data-id");
		// if(confirm("Do you really want to delete this currency?")==false){
		// 	return false;
		// }
		$.ajax({
			type: "POST",
			url: "/admin/storefront/cms/faq/delete",
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
			data: {id},
			dataType: "json",
			success: function(data){
				console.log(data);
				var colour="";
				if(data.status=="success"){
					clicked.closest("tr").hide();
					success_msg(data.msg);
				}
				return false;
			},
			error: function(e){
				console.log(e.responseText);
				return false;
			}
		});/* end of ajax */
		return false;
	});/* end of click function */
</script>
@stop