<?php 
	use App\Models\Option; 
	use App\Models\Productdetails; 
	use App\Models\OfferSliders; 
?>
@extends("backend/master")
@section('maincontent')
@section('styles')
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css') !!}
@stop
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li> 
					<li class="active">Store Frontend</li> 
					<li class="active">Add Offer Sliders</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Offer Sliders</h1>
						<article class="margin-bottom-xxl">
							<p class="lead">Offer Sliders for your store can be managed here. An offer slider is a way to express the offers on that particular products.</p>
						</article>
					</div><!--end .col -->

					<div class="clearfix"></div>

					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
					@if(Session::has('error')) {!! HTML::display_error('error') !!} @endif

					<?php 
						$offerSliders = OfferSliders::all();
					 ?>

					<div class="col-md-5">
						<!-- ****************** FORM START HERE ***************** -->
						{!! Form::open(["url"=>"admin/storefront/offer/sliders","class"=>"form","id"=>"offerSliders","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Add New Offer Slider</header>
								</div>
								@if(count($offerSliders) < 5)
									<div class="card-body">
										<div class="form-group @if($errors->has('HPOfferSlider'))has-error @endif">
											{!! HTML::decode(Form::label("HPOfferSlider","Upload Offer Slider Image <span class='text-danger'></span>")) !!}<br>
											{!! Form::file("HPOfferSlider",["class"=>"form-control"]) !!}
											<p class="help-block">Recommended Resolution 1440px x 960px</p>
											@if($errors->has("HPOfferSlider"))
												<span id="HPOfferSlider-error" class="help-block">{!! $errors->first("HPOfferSlider") !!}</span>
											@endif
										</div><!--end form-group-->

										<div class="form-group">
											<div class="checkbox checkbox-styled">
												<label>
													{!! Form::checkbox("allProducts","yes", "",["id"=>"allProducts"]) !!}
													<span>Link To All Products</span>
												</label>
											</div>
										</div>

										<?php
											$products = Productdetails::where("productstatus", "online")->pluck("productname", "id");
										?>

										<div class="form-group @if($errors->has('linkProduct'))has-error @endif" id="linkToProductsDiv">
											{!! Form::select("linkProduct",$products,"",["class"=>"form-control","placeholder"=>"Select Product"]) !!}
											@if($errors->has("linkProduct"))
												<span id="linkProduct-error" class="help-block">{!! $errors->first("linkProduct") !!}</span>
											@endif
											{!! HTML::decode(Form::label("linkProduct","Product to Link<span class='text-danger'>*</span>")) !!}
										</div><!--end form-group-->
									</div><!--end .card-body -->

									<div class="card-actionbar">
										<div class="card-actionbar-row">
											<button type="submit" id="addcategory" class="btn ink-reaction btn-primary-dark">Add Offer Slider</button>
										</div>
									</div>
								@endif
							</div><!--end .card -->
						{!! Form::close() !!}
							<!-- ****************** FORM START HERE ***************** -->
					</div><!--end .col -->

					<div class="col-md-7">
						<div class="card">
							<div class="card-head style-primary">
								<header>List of Offer Sliders</header>
							</div>
							<div class="card-body">
							<div class="table-responsive">

								<table id="offerSliderTable" class="table table-striped table-hover">
									<thead>
										<tr>
											<th>Current Offer Slider</th>
											<th>Delete</th>
										</tr>
									</thead>
									<tbody>
										@foreach($offerSliders as $slider)
											<tr>
												<td class="col-md-6">{!! HTML::image($slider->offerSlider, "Offer Slider", ["class"=>"col-md-6"]) !!}</td>
												<td><center><span class="btn ink-reaction btn-sm btn-primary deleteOfferSlider" data-id="{!! $slider->id !!}">Delete</span></center></td>
											</tr>
										@endforeach
									</tbody>
								</table>
							</div><!--end .table-responsive -->
							</div><!--end card-body-->
						</div>
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js') !!}
	{!! HTML::script('backend/js/bala.js') !!}
	<script type="text/javascript">
		$(document).ready(function()
		{
		    $("#offerSliderTable").dataTable();
		});
	</script>
@stop