@extends("backend/master")
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/summernote/summernote.css')!!}
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Store Frontend</li>
					<li class="active">CMS</li>
					<li class="active">Privacy Policy</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">CMS Pages</h1>
					</div><!--end .col -->
					<div class="col-md-3">
						<div class="card">
						<div class="card-body no-padding">
							<ul class="list">
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-dashboard"></i>
									</a>
									<a href="{{URL::to('admin/storefront/cms/about')}}" class="tile-content ink-reaction">
										<div class="tile-text">About</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction active">
										<i class="md md-credit-card"></i>
									</a>
									<a href="{{URL::to('admin/storefront/cms/privacy')}}" class="tile-content ink-reaction tile-active">
										<div class="tile-text">Privacy Policy</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-local-mall"></i>
									</a>
									<a href="{{URL::to('admin/storefront/cms/terms')}}" class="tile-content ink-reaction">
										<div class="tile-text">Terms & Conditions</div>
									</a>
								</li>
								<li class="tile">
									<a class="btn btn-flat ink-reaction">
										<i class="md md-filter-1"></i>
									</a>
									<a href="{{URL::to('admin/storefront/cms/faq')}}" class="tile-content ink-reaction">
										<div class="tile-text">FAQ</div>
									</a>
								</li>
							</ul>
						</div><!--end .card-body -->
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(['url'=>'admin/storefront/cms/privacy','class'=>'form']) !!}
						<div class="card">
							<div class="card-head style-primary">
								<header>Privacy Policy</header>
							</div>
							@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
							<div class="card-body">

								<div class="form-group @if($errors->has('pageTitle'))has-error @endif">
									{!! Form::text("pageTitle",$title,["class"=>"form-control"]) !!}
											@if($errors->has("pageTitle"))
												<span id="pageTitle-error" class="help-block">{!! $errors->first("pageTitle") !!}</span>
											@endif
											{!! HTML::decode(Form::label("pageTitle","Page Title<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('pageContent'))has-error @endif">
									{!! Form::textarea("pageContent",$content,["class"=>"form-control",'id'=>'pageContent']) !!}
											@if($errors->has("pageContent"))
												<span id="pageContent-error" class="help-block">{!! $errors->first("pageContent") !!}</span>
											@endif
											{!! HTML::decode(Form::label("pageContent","Page Content<span class='text-danger'>*</span>")) !!}
									</div>

							</div><!--end .card-body -->
							<div class="card-actionbar">
								<div class="card-actionbar-row">
									<button type="submit" class="btn ink-reaction btn-primary-dark">Save Changes</button>
								</div>
							</div>
						</div><!--end .card -->
						<em class="text-caption">Vertical layout with static labels</em>
					{!! Form::close() !!}
					</div><!-- end of col-md-8 -->

				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/assets/js/libs/summernote/summernote.min.js')!!}
{!!HTML::script('backend/assets/js/libs/global/iframe-transport.js')!!}
{!!HTML::script('backend/assets/js/libs/global/jquery-ui.js')!!}
{!!HTML::script('backend/assets/js/libs/global/fileupload.js')!!}
<script type="text/javascript">
	$(document).ready(function() {
	  $('#pageContent').summernote();
	});
</script>
@stop