<?php 
	use App\Models\Returnstatuses; 
	use App\Models\Option; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Store Frontend</li>
					<li class="active">Social</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Theme Options</h1>
					</div><!--end .col -->
					<div class="col-md-3">
						@include("backend/storefront/storeFrontSidebar", ["page"=>"social"])
					</div><!--end .col -->
					<div class="col-md-6">
						<form class="form" id="socialform">
						<div class="card">
							<div class="card-head style-primary">
								<header>Social</header>
							</div>
							<div class="card-body">
									<div class="form-group">
										<input type="text" id="social_facebooklink" name="social_facebooklink" class="form-control" value="{{Option::getvalue('social_facebooklink')}}">
										<label for="social_facebooklink">Facebook</label>
										<p class="help-block">Paste your facebook link</p>
									</div><!--end form-group-->

									<div class="form-group">
										<input type="text" id="social_twitterlink" name="social_twitterlink" class="form-control" value="{{Option::getvalue('social_twitterlink')}}">
										<label for="social_twitterlink">Twitter</label>
										<p class="help-block">Paste your twitter link</p>
									</div><!--end form-group-->

									<div class="form-group">
										<input type="text" id="social_googlepluslink" name="social_googlepluslink" class="form-control" value="{{Option::getvalue('social_googlepluslink')}}">
										<label for="social_googlepluslink">Google Plus</label>
										<p class="help-block">Paste your google plus link</p>
									</div><!--end form-group-->

									<div class="form-group">
										<input type="text" id="social_linkedinlink" name="social_linkedinlink" class="form-control" value="{{Option::getvalue('social_linkedinlink')}}">
										<label for="social_linkedinlink">Linked in</label>
										<p class="help-block">Paste your linked in link</p>
									</div><!--end form-group-->

									<div class="form-group">
										<input type="text" id="social_pinterestlink" name="social_pinterestlink" class="form-control" value="{{Option::getvalue('social_pinterestlink')}}">
										<label for="social_pinterestlink">Pinterest</label>
										<p class="help-block">Paste your pinterest link</p>
									</div><!--end form-group-->

									<div class="form-group">
										<input type="text" id="social_youtubelink" name="social_youtubelink" class="form-control" value="{{Option::getvalue('social_youtubelink')}}">
										<label for="social_youtubelink">Youtube</label>
										<p class="help-block">Paste your Youtube link</p>
									</div><!--end form-group-->

									<div class="form-group">
										<input type="text" id="social_instagramlink" name="social_instagramlink" class="form-control" value="{{Option::getvalue('social_instagramlink')}}">
										<label for="social_instagramlink">Instagram</label>
										<p class="help-block">Paste your Instagram link</p>
									</div><!--end form-group-->

									<div class="form-group">
										<h3>Share Icons</h3>
									   <?php if(Option::getvalue('social_facebookicon') == 'true'){ $check = 'checked'; }else{ $check = ''; } ?>
										<div class="checkbox checkbox-styled">
											<label>
												<input type="checkbox" name="social_facebookicon" value="true" <?php echo $check; ?> >
												<span>Facebook</span>
											</label>
										</div>
										<?php if(Option::getvalue('social_twittericon') == 'true'){ $check = 'checked'; }else{ $check = ''; } ?>
										<div class="checkbox checkbox-styled">
											<label>
												<input type="checkbox" name="social_twittericon" value="true" <?php echo $check; ?> >
												<span>Twitter</span>
											</label>
										</div>
									</div>
							</div><!--end .card-body -->
							<div class="card-actionbar">
								<div class="card-actionbar-row">
									<button type="submit" id="savesocialsettings" class="btn ink-reaction btn-primary-dark">Save Changes</button>
								</div>
							</div>
						</div><!--end .card -->
					</form>
					</div><!-- end of col-md-8 -->

				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!! HTML::script('backend/assets/js/libs/global/iframe-transport.js') !!}
{!! HTML::script('backend/assets/js/libs/global/jquery-ui.js') !!}
{!! HTML::script('backend/assets/js/libs/global/fileupload.js') !!}
{!! HTML::script('backend/js/catalogfunction.js') !!} 
@stop