<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Testmonials</li>
					<li class="active">Modify Testimonial</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Modify Testimonial</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/testimonials/get","Manage Testimonials",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/testimonials/modify/post/".$testimonial->id,"class"=>"form","enctype"=>"multipart/form-data","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Modify Testimonial</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									
									<div class="form-group @if($errors->has('testimonialContent'))has-error @endif">
									{!! HTML::decode(Form::label("testimonialContent","Testimonial Content <span class='text-danger'>*</span>")) !!}
									{!! Form::textarea("testimonialContent",$testimonial->testimonialContent,["class"=>"form-control"]) !!}
										@if($errors->has("testimonialContent"))
											<span id="testimonialContent-error" class="help-block">{!! $errors->first("testimonialContent") !!}</span>
										@endif
									</div>

									<div class="form-group @if($errors->has('authName'))has-error @endif">
										{!! Form::text("authName",$testimonial->authName,["class"=>"form-control"]) !!}
											@if($errors->has("authName"))
												<span id="authName-error" class="help-block">{!! $errors->first("authName") !!}</span>
											@endif
										{!! HTML::decode(Form::label("authName","Author Name <span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('authCategory'))has-error @endif">
										{!! Form::text("authCategory",$testimonial->authCategory,["class"=>"form-control"]) !!}
											@if($errors->has("authCategory"))
												<span id="authCategory-error" class="help-block">{!! $errors->first("authCategory") !!}</span>
											@endif
										{!! HTML::decode(Form::label("authCategory","Author Category <span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('featureImage'))has-error @endif">
										<div class="row">
											<div class="col-lg-3">
												@if($testimonial->authImg != "")
													<?php //'http://bodyfuelz.dev/frontend/img/team4.jpg') ?>
													<img src="{!! URL::asset($testimonial->authImg) !!}" class="img-responsive admin_img">
												@endif
											</div>
												
											
											<div class="col-lg-5">
												{!! HTML::decode(Form::label("authImg","Author Image")) !!}
												{!! Form::file("authImg",["class"=>"form-control"]) !!}
												@if($errors->has("authImg"))
													<span id="authImg-error" class="help-block">{!! $errors->first("authImg") !!}</span>
												@endif
											</div>
										</div>
									</div>

								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Modify Testimonial</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	      CKEDITOR.replace('testimonialContent');
	    });
	</script>
@stop