<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Users</li>
					<li class="active">Add New Admim Member</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add New Admim Member</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/users","Manage Admim Members",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/users/add","class"=>"form"]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Create user</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									<div class="row">
										<div class="col-sm-6">
											<div class="form-group @if($errors->has('firstName'))has-error @endif">
												{!! Form::text("firstName","",["class"=>"form-control"]) !!}
													@if($errors->has("firstName"))
														<span id="firstName-error" class="help-block">{!! $errors->first("firstName") !!}</span>
													@endif
												{!! HTML::decode(Form::label("firstName","First Name<span class='text-danger'>*</span>")) !!}
											</div>
										</div>
										<div class="col-sm-6">
											<div class="form-group @if($errors->has('lastName'))has-error @endif">
												{!! Form::text("lastName","",["class"=>"form-control"]) !!}
													@if($errors->has("lastName"))
														<span id="lastName-error" class="help-block">{!! $errors->first("lastName") !!}</span>
													@endif
												{!! HTML::decode(Form::label("lastName","Last Name<span class='text-danger'>*</span>")) !!}
											</div>
										</div>
									</div>

									<div class="form-group @if($errors->has('userName'))has-error @endif">
									{!! Form::text("userName","",["class"=>"form-control"]) !!}
											@if($errors->has("userName"))
												<span id="userName-error" class="help-block">{!! $errors->first("userName") !!}</span>
											@endif
											{!! HTML::decode(Form::label("userName","User Name<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('email'))has-error @endif">
									{!! Form::text("email","",["class"=>"form-control"]) !!}
											@if($errors->has("email"))
												<span id="email-error" class="help-block">{!! $errors->first("email") !!}</span>
											@endif
											{!! HTML::decode(Form::label("email","Email<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('address'))has-error @endif">
									{!! Form::textarea("address","",["class"=>"form-control","rows"=>"4"]) !!}
											@if($errors->has("address"))
												<span id="address-error" class="help-block">{!! $errors->first("address") !!}</span>
											@endif
											{!! HTML::decode(Form::label("address","Address<span class='text-danger'></span>")) !!}
									</div>

									<?php
										$country = DB::table("location")->where("status","active")->where("locationType",0)->pluck("name","id");
										//print_r($country);
									?>

									<div class="form-group @if($errors->has('country'))has-error @endif">
									{!! Form::select("country",$country,"",["class"=>"form-control","id"=>"country","placeholder"=>"Select Country"]) !!}
											@if($errors->has("country"))
												<span id="country-error" class="help-block">{!! $errors->first("country") !!}</span>
											@endif
											{!! HTML::decode(Form::label("country","Country<span class='text-danger'></span>")) !!}
									</div>

									<div class="form-group @if($errors->has('state'))has-error @endif">
									{!! Form::select("state",[""=>"Select State"],"",["class"=>"form-control","id"=>"state"]) !!}
											@if($errors->has("state"))
												<span id="state-error" class="help-block">{!! $errors->first("state") !!}</span>
											@endif
											{!! HTML::decode(Form::label("state","State<span class='text-danger'></span>")) !!}
									</div>

									<div class="form-group @if($errors->has('phone'))has-error @endif">
									{!! Form::text("phone","",["class"=>"form-control"]) !!}
											@if($errors->has("phone"))
												<span id="phone-error" class="help-block">{!! $errors->first("phone") !!}</span>
											@endif
											{!! HTML::decode(Form::label("phone","Phone<span class='text-danger'></span>")) !!}
									</div>

									<div class="form-group @if($errors->has('city'))has-error @endif">
									{!! Form::text("city","",["class"=>"form-control"]) !!}
											@if($errors->has("city"))
												<span id="city-error" class="help-block">{!! $errors->first("city") !!}</span>
											@endif
											{!! HTML::decode(Form::label("city","City<span class='text-danger'></span>")) !!}
									</div>

									<div class="form-group @if($errors->has('pincode'))has-error @endif">
									{!! Form::text("pincode","",["class"=>"form-control"]) !!}
											@if($errors->has("pincode"))
												<span id="pincode-error" class="help-block">{!! $errors->first("pincode") !!}</span>
											@endif
											{!! HTML::decode(Form::label("pincode","Pincode<span class='text-danger'></span>")) !!}
									</div>

									<div class="form-group @if($errors->has('userGroup'))has-error @endif">
									{!! Form::select("userGroup",$usergroup,"",["class"=>"form-control","placeholder"=>"Select User Group"]) !!}
											@if($errors->has("userGroup"))
												<span id="userGroup-error" class="help-block">{!! $errors->first("userGroup") !!}</span>
											@endif
											{!! HTML::decode(Form::label("userGroup","User Group<span class='text-danger'>*</span>")) !!}
									</div>

								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add User</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/js/bala.js')!!}
@stop