<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>
@extends("backend/master")
@section('maincontent')
<!-- BEGIN CONTENT-->
<div id="content">
<section>
	<div class="section-header ">
		<ol class="breadcrumb">
			<li class="active">Home</li>
			<li class="active">Users</li>
			<li>Add New Seller</li>
		</ol>
	</div>

	<div class="section-body">
		<!-- BEGIN VERTICAL FORM -->
		<div class="row">
			<div class="col-lg-12">
				<h1 class="text-primary">Add New Seller</h1>
			</div><!--end .col -->
			<div class="col-lg-2 col-md-4">
				
				<div class="section-header">
					{!! HTML::link("admin/users/sellers","Manage Sellers",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
				</div>
			</div><!--end .col -->
			<div class="col-md-10">
				{!! Form::open(['url'=>'admin/users/sellers/add/post','class'=>'form']) !!}
				<div class="card">
					<div class="card-head style-primary">
						<header>Add New Seller</header>
					</div>
					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
					<div class="card-body">
						<div class="row">
							<div class="col-md-6">
								<div class="row">
									<div class="col-sm-6">
										<div class="form-group @if($errors->has('firstname'))has-error @endif">
											{!! Form::text("firstname","",["class"=>"form-control"]) !!}
											@if($errors->has("firstname"))
												<span id="firstname-error" class="help-block">{!! $errors->first("firstname") !!}</span>
											@endif
											{!! HTML::decode(Form::label("firstname","Firstname<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group @if($errors->has('lastname'))has-error @endif">
											{!! Form::text("lastname","",["class"=>"form-control"]) !!}
											@if($errors->has("lastname"))
												<span id="lastname-error" class="help-block">{!! $errors->first("lastname") !!}</span>
											@endif
											{!! HTML::decode(Form::label("lastname","Lastname<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group @if($errors->has('companyname'))has-error @endif">
											{!! Form::text("companyname","",["class"=>"form-control"]) !!}
											@if($errors->has("companyname"))
												<span id="companyname-error" class="help-block">{!! $errors->first("companyname") !!}</span>
											@endif
											{!! HTML::decode(Form::label("companyname","Company Name<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group @if($errors->has('email'))has-error @endif">
											{!! Form::text("email","",["class"=>"form-control"]) !!}
											@if($errors->has("email"))
												<span id="email-error" class="help-block">{!! $errors->first("email") !!}</span>
											@endif
											{!! HTML::decode(Form::label("email","Email<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group @if($errors->has('address'))has-error @endif">
											{!! Form::textarea("address","",["class"=>"form-control","rows"=>2]) !!}
											@if($errors->has("address"))
												<span id="address-error" class="help-block">{!! $errors->first("address") !!}</span>
											@endif
											{!! HTML::decode(Form::label("address","Address<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group @if($errors->has('country'))has-error @endif">
											{!! Form::select("country",[""=>"Select Country"]+$country,"",["class"=>"form-control","id"=>"country"]) !!}
												@if($errors->has("country"))
													<span id="country-error" class="help-block">{!! $errors->first("country") !!}</span>
												@endif
											{!! HTML::decode(Form::label("country","Country<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group @if($errors->has('state'))has-error @endif">
											{!! Form::select("state",[""=>"Select State"],"",["class"=>"form-control","id"=>"state"]) !!}
												@if($errors->has("state"))
													<span id="state-error" class="help-block">{!! $errors->first("state") !!}</span>
												@endif
											{!! HTML::decode(Form::label("state","State<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group @if($errors->has('city'))has-error @endif">
											{!! Form::select("city",[""=>"Select City"],"",["class"=>"form-control","id"=>"city"]) !!}
												@if($errors->has("city @if($errors->has('lastName'))has-error @endif"))
													<span id="city-error" class="help-block">{!! $errors->first("city") !!}</span>
												@endif
											{!! HTML::decode(Form::label("city","City<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group @if($errors->has('phone'))has-error @endif">
											{!! Form::text("phone","",["class"=>"form-control"]) !!}
											@if($errors->has("phone"))
												<span id="phone-error" class="help-block">{!! $errors->first("phone") !!}</span>
											@endif
											{!! HTML::decode(Form::label("phone","Phone<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group @if($errors->has('pincode'))has-error @endif">
											{!! Form::text("pincode","",["class"=>"form-control"]) !!}
											@if($errors->has("pincode"))
												<span id="pincode-error" class="help-block">{!! $errors->first("pincode") !!}</span>
											@endif
											{!! HTML::decode(Form::label("pincode","Pincode<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group @if($errors->has('userRole'))has-error @endif">
											{!! Form::select("userRole",[""=>"Select User Role"]+$roles,"",["class"=>"form-control","id"=>"userRole"]) !!}
												@if($errors->has("userRole"))
													<span id="userRole-error" class="help-block">{!! $errors->first("userRole") !!}</span>
												@endif
											{!! HTML::decode(Form::label("userRole","User Role<span class='text-danger'>*</span>")) !!}
											<label for="select1">User Role<span class="text-danger">*</span></label>
										</div>
									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="card">
									<div class="card-head">
										<header>Company Details</header>
									</div><!--end .card-head -->
									<div class="card-body">
										<div class="form-group @if($errors->has('image'))has-error @endif">
											<input type="text" value="" class="form-control" name="image" id="header_logo">
											<label for="uploadLogo">Upload Company Logo</label>
											<p class="help-block">Please upload seller's company logo.</p>
										</div>
										<p>
										<button type="button" id="headerlogobox" class="btn ink-reaction btn-raised btn-sm btn-primary">Upload</button> &nbsp;&nbsp;
										<button type="button" id="header_removelogo" class="btn ink-reaction btn-raised btn-sm btn-default">Remove</button>
										<div class="progress progress-striped active" id="logoprogressbox" style="display:none;">
												    <div class="progress-bar progress-bar-warning" id="logoprogress"></div>
									</div>
										<input type="file" id="headerlogo" style="display:none;">
										</p>
										<div class="row">
										<div class="col-md-3" id="logoplace"><img class="uploadedImage" src=""></div>
										<!-- http://shopem.dev/uploads/2015/10/logo.png -->
										</div>

										<br>
										
										<div class="form-group @if($errors->has('shortInfo'))has-error @endif">
											{!! Form::textarea("shortInfo","",["class"=>"form-control","rows"=>2]) !!}
											@if($errors->has("shortInfo"))
												<span id="shortInfo-error" class="help-block">{!! $errors->first("shortInfo") !!}</span>
											@endif
											{!! HTML::decode(Form::label("shortInfo","Company Short Info<span class='text-danger'>*</span>")) !!}
										</div>
									</div>
								</div>
							</div><!--end col-md-6-->
						</div><!--end row-->
					</div><!--end card-body-->
					<div class="card-actionbar">
						<div class="card-actionbar-row">
							<button class="btn ink-reaction btn-primary-dark" type="submit">Add Seller</button>
						</div>
					</div>
					{!! Form::close() !!}
				</div><!--end col-md-10-->
			</div>
		</div>
	</div>
</section>
</div>

@stop


@section('script')
	{!!HTML::script('backend/assets/js/libs/global/iframe-transport.js')!!}
	{!!HTML::script('backend/assets/js/libs/global/jquery-ui.js')!!}
	{!!HTML::script('backend/assets/js/libs/global/fileupload.js')!!}
	{!!HTML::script('backend/js/adminmenu.js')!!}
	<script type="text/javascript">
	$('select').select2();
	$(document).on("change","#country",function(){
    var id=$(this).val();
    $("#state").select2("val", "");
    $.ajax({
      type: "POST",
      url:  "/admin/country/state/lists",
      headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
      data: {id},
      dataType: "json",
      success: function(data){
        console.log(data);
        $("#state").empty();
        if(data.count>0){
          $("#state").append("<option value=''>Select State</option>");
          $.each(data.states,function(key,val){
            $("#state").append("<option value='"+key+"'>"+val+"</option>");
          });
        }
        else{
          $("#state").append("<option value=''>No state found for this country</option>");
        }
        return false;
      },
      error: function(e){
        console.log(e.responseText);
        return false;
      }
    });/* end of ajax */
  });/* end of change function */


  $(document).on("change","#state",function(){
    var state=$(this).val();
    $.ajax({
      type: "POST",
      url:  "/admin/masters/locations/city/option/post",
      headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
      data: {state},
      dataType: "json",
      success: function(data){
        console.log(data);
        if(data.count>0){
          $('#city').empty().append(data.result);
        }
        else{
          error_msg("No records found");
          return false;
        }
        
      },
      error: function(e){
        console.log(e.responseText);
        return false;
      }
    });/* end of ajax */
    return false;
  });/* end of click function */

  $('#headerlogobox').click(function () { $("#headerlogo").trigger('click'); });
  $('#headerlogo').fileupload({
            url: '/imageupload',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
            dataType: 'json',
            formData: { path:'' },
            done: function (e, data) {
                var baseurl = document.location.origin;
                var src = baseurl+'/'+data.result.files[0].url;
                $('#logoplace').html('').html('<img src="'+src+'" id="logoplace" class="uploadedImage">');
                $('#header_logo').val(src);
                storeimages(src,'header_logo');
                console.log(src);
            },
            progressall: function (e, data) {
                $('#logoprogressbox').show();
                var progress = parseInt(data.loaded / data.total * 100, 10);
                $('#logoprogress').css(
                    'width',
                    progress + '%'
                ).text(progress+'%');
            },error: function(e){
              console.log(e.responseText);
            }
        }).prop('disabled', !$.support.fileInput)
        .parent().addClass($.support.fileInput ? undefined : 'disabled');

        function storeimages(u,key){
  $.ajax({
      url: '/storeimages' ,
      data: { u:u,key:key },
      dataType: 'json',
      type: 'GET',
      success: function(res){
         $('.progress').next().css('width','0%').text(''); $('.progress').hide();
        console.log(res); return false;
      },error: function(e){
         $('.progress').next().css('width','0%').text(''); $('.progress').hide();
        console.log(e.responseText); alert('Error Processing your request.'); return false;
      }
  });
}
  </script>
@stop