<?php 
	use App\Models\User;
	use App\Models\Adminmenumanage;  
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">User Roles</li>
					<li>Add New User Role</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add New User Role</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/users/role","Manage User Roles",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["class"=>"form",'id'=>'adduserroleForm']) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Add user role</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									<div class="row">
										<div class="form-group">
											{!! Form::text("roleName","",["class"=>"form-control",'id'=>'roleName']) !!}
											{!! HTML::decode(Form::label("roleName","Role Name<span class='text-danger'>*</span>")) !!}
										</div>
									</div>

									<div class="table-responsive">
						<table class="table table-striped table-hover">
							<thead>
								<tr>
									<th>Name</th>
									<th>View <input type="checkbox" class="selectAll view"></th>
									<th>Create <input type="checkbox" class="selectAll create"></th></th>
									<th>Update <input type="checkbox" class="selectAll update"></th></th>
									<th>Delete <input type="checkbox" class="selectAll delete"></th></th>
									<!-- <th>Edit</th> -->
								</tr>
							</thead>
							<tbody>
							
							@foreach($menus as $first)
							<?php $firstname=Adminmenumanage::getmenuname($first->menuId); ?>
							<tr>
								<td>{!! $firstname !!}<input type="hidden" value="{!! $first->menuId !!}" class="menuId" name="menuIds[]"></td>
								<td><input type="checkbox" class="single viewClass" name="viewClass[]"></td>
								<td><input type="checkbox" class="single createClass" name="createClass[]"></td>
								<td><input type="checkbox" class="single updateClass" name="updateClass[]"></td>
								<td><input type="checkbox" class="single deleteClass" name="deleteClass[]"></td>
							</tr>

							@if(Adminmenumanage::hasSubmenu($first->menuId)>0)
								@foreach(Adminmenumanage::getSubmenu($first->menuId) as $second)
								<?php $secondname=Adminmenumanage::getmenuname($second->menuId); ?>
								<tr>
									<td>{!! $firstname." -> ".$secondname !!}<input type="hidden" value="{!! $second->menuId !!}" class="menuId" name="menuIds[]"></td>
								<td><input type="checkbox" class="single viewClass" name="viewClass[]"></td>
								<td><input type="checkbox" class="single createClass" name="createClass[]"></td>
								<td><input type="checkbox" class="single updateClass" name="updateClass[]"></td>
								<td><input type="checkbox" class="single deleteClass" name="deleteClass[]"></td>
								</tr>
								@if(Adminmenumanage::hasSubmenu($second->menuId)>0)
									@foreach(Adminmenumanage::getSubmenu($second->menuId) as $third)
									<?php $thirdname=Adminmenumanage::getmenuname($third->menuId); ?>
									<tr>
										<td>{!! $firstname." -> ".$secondname." -> ".$thirdname !!}<input type="hidden" value="{!! $third->menuId !!}" class="menuId" name="menuIds[]"></td>
								<td><input type="checkbox" class="single viewClass" name="viewClass[]"></td>
								<td><input type="checkbox" class="single createClass" name="createClass[]"></td>
								<td><input type="checkbox" class="single updateClass" name="updateClass[]"></td>
								<td><input type="checkbox" class="single deleteClass" name="deleteClass[]"></td>
									</tr>
									@endforeach
								@endif
								@endforeach
							@endif
							@endforeach
							</tbody>
						</table>
					</div>

									
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark saveUserrole">Add User Role</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!! HTML::script('backend/js/adminmenu.js') !!}
<script type="text/javascript">
	$(document).on('click','.selectAll',function(){
		var selected=$(this);
		if(selected.hasClass('view')){
			if(selected.is(':checked')){
				$('.viewClass').prop('checked',true);
			}else{
				$('.viewClass').prop('checked',false);
			}
		}

		if(selected.hasClass('create')){
			if(selected.is(':checked')){
				$('.createClass').prop('checked',true);
			}else{
				$('.createClass').prop('checked',false);
			}
		}


		if(selected.hasClass('update')){
			if(selected.is(':checked')){
				$('.updateClass').prop('checked',true);
			}else{
				$('.updateClass').prop('checked',false);
			}
		}

		if(selected.hasClass('delete')){
			if(selected.is(':checked')){
				$('.deleteClass').prop('checked',true);
			}else{
				$('.deleteClass').prop('checked',false);
			}
		}	
	});

	$(document).on('click','.single',function(){
		var selected=$(this);
		if(selected.hasClass('viewClass')){
			if(selected.is(':checked')){
				selected.parent().parent().find('.viewClass').prop('checked',true);
				if($('.viewClass:checked').length==$('.viewClass').length){
					$('.view').prop('checked',true);
				}
			}else{
				selected.parent().parent().find('input').prop('checked',false);
				$('.view').prop('checked',false);
			}
		}

		if(selected.hasClass('createClass')){
			if(selected.is(':checked')){
				selected.parent().parent().find('.createClass').prop('checked',true);
				if($('.createClass:checked').length==$('.createClass').length){
					$('.create').prop('checked',true);
				}
				selected.parent().parent().find('.viewClass').prop('checked',true);
			}else{
				selected.parent().parent().find('.createClass').prop('checked',false);
				$('.create').prop('checked',false);
			}
		}


		if(selected.hasClass('updateClass')){
			if(selected.is(':checked')){
				selected.parent().parent().find('.updateClass').prop('checked',true);
				if($('.updateClass:checked').length==$('.updateClass').length){
					$('.update').prop('checked',true);
				}
				selected.parent().parent().find('.viewClass').prop('checked',true);
			}else{
				selected.parent().parent().find('.updateClass').prop('checked',false);
				$('.update').prop('checked',false);
			}
		}

		if(selected.hasClass('deleteClass')){
			if(selected.is(':checked')){
				selected.parent().parent().find('.deleteClass').prop('checked',true);
				if($('.deleteClass:checked').length==$('.deleteClass').length){
					$('.delete').prop('checked',true);
				}
				selected.parent().parent().find('.viewClass').prop('checked',true);
			}else{
				selected.parent().parent().find('.deleteClass').prop('checked',false);
				$('.delete').prop('checked',false);
			}
		}

	});
	

	$(document).on('click','.saveUserrole',function(){
		$('.has-error').removeClass('has-error');
		var roleName=$('#roleName').val();
		if(roleName==''){
			$('#roleName').parent().addClass('has-error');
			error_msg('Please enter user role name.');
			return false;
		}
		var record=[];
		$('#adduserroleForm tbody tr').each(function(){
			var menuId=$(this).find('.menuId').val();
			if($(this).find('.viewClass').is(':checked')){
				var view=1;
			}else{
				var view=0;
			}

			if($(this).find('.createClass').is(':checked')){
				var create=1;
			}else{
				var create=0;
			}

			if($(this).find('.updateClass').is(':checked')){
				var update=1;
			}else{
				var update=0;
			}

			if($(this).find('.deleteClass').is(':checked')){
				var deleteId=1;
			}else{
				var deleteId=0;
			}

			var details={menuId:menuId,view:view,create:create,update:update,deleteId:deleteId};
			record.push(details);
		});
		$.ajax({
		    url:'/admin/users/role/add', 
		    data: { roleName:roleName,details:record },
		    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
		    dataType:'json', 
		    type:'POST',
		    success: function(res){ 
		    	console.log(res);
		      if(res.status == 'success'){ 
		      	$(':checkbox').prop('checked',false);
		      	$('#roleName').val('');
		      	success_msg(res.msg); 
		      }else if(res.status=='validation'){
		      	error_msg(res.val);
		      }else{
		      	error_msg('Error Found.');
		      }
		    }, error: function(e){ 
		    	console.log(e.responseText); 
		    }
		  }); 
		return false;
	});


</script>
@stop