<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Profile</li>
					<li class="active">Change Password</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Change Password</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/users","Manage Admim Members",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/users/change/password","class"=>"form"]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Change Password</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								@if(Session::has('error')) {!! HTML::display_error('error') !!} @endif
								<div class="card-body">
									<div class="form-group @if($errors->has('currentPassword'))has-error @endif">
									{!! Form::password("currentPassword",["class"=>"form-control"]) !!}
											@if($errors->has("currentPassword"))
												<span id="currentPassword-error" class="help-block">{!! $errors->first("currentPassword") !!}</span>
											@endif
											{!! HTML::decode(Form::label("currentPassword","Current Password<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('newPassword'))has-error @endif">
									{!! Form::password("newPassword",["class"=>"form-control"]) !!}
											@if($errors->has("newPassword"))
												<span id="newPassword-error" class="help-block">{!! $errors->first("newPassword") !!}</span>
											@endif
											{!! HTML::decode(Form::label("newPassword","New Password<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('confirmPassword'))has-error @endif">
									{!! Form::password("confirmPassword",["class"=>"form-control"]) !!}
											@if($errors->has("confirmPassword"))
												<span id="confirmPassword-error" class="help-block">{!! $errors->first("confirmPassword") !!}</span>
											@endif
											{!! HTML::decode(Form::label("confirmPassword","Confirm Password<span class='text-danger'>*</span>")) !!}
									</div>
								</div><!--end .card-body -->
								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Change Password</button>
									</div>
								</div>
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/js/bala.js')!!}
@stop