<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Usergroup;

	$updatePermission = Usergroup::getupdatepermission(Auth::User()->userGroup, 12);
	$deletePermission = Usergroup::getdeletepermission(Auth::User()->userGroup, 12);
	$addPermission = Usergroup::getupdatepermission(Auth::User()->userGroup, 12);
?>
@extends("backend/master")
@section('styles')
{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css') !!}
{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css') !!}
{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css') !!}
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Users</li>
					<li>Online Users</li>
				</ol>
			</div>
			<div class="section-header">
				<h2 class="text-primary">Customers / Online Users</h2>
			</div>
		
			<div class="section-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="row">
							{!! Form::open(['url'=>'admin/customers/manage/search','class'=>'form']) !!}
								<div class="col-lg-2">
									<div class="form-group floating-label">
										<input id="searchProduct" name="searchName" class="form-control" type="text">
										<label for="searchProduct">Search Customers</label>
									</div>
								</div>

								<div class="col-lg-1">
									<div class="form-group">
									<input type="submit" value="search" class="btn ink-reaction btn-info-dark pull-right">
									</div>
								</div>
							{!! Form::close() !!}
						</div>

						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Name</th>
										<th>Email</th>
										<th>Created On</th>
										<th>Last Login</th>
										<th>IP Address</th>
										<th class="sort-numeric">Status</th>
										@if(($updatePermission == true || $deletePermission == true || Auth::User()->userGroup == 1))
											<th class="sort-alpha">Actions</th>
										@endif
									</tr>
								</thead>
								<tbody>
									<?php $i = 1; $count = 1; ?>
									@foreach($customers as $customer)
										<tr class="gradeX">
											<td>{!! (($customers->currentPage() - 1 ) * $customers->perPage()) + $i !!}</td>
											<td>{!! $customer->firstName.$customer->lastName !!}</td>
											<td>{!! $customer->email !!}</td>
											<td>{!! date(Option::getvalue("dateFormat")." ".Option::getvalue("timeFormat"),strtotime($customer->created_at)) !!}</td>
											<td>{!! $customer->lastLogin !!}</td>
											<td>{!! $customer->ipAddress !!}</td>
											<?php
												$customer->status=="active"?$class="success":$class="danger";
											?>
											<td><button type="button" class="btn ink-reaction btn-xs btn-{!! $class !!} customerStatus" data-id="{!! $customer->id !!}">{!! ucfirst($customer->status) !!}</button></td>
											<td>
												@if($updatePermission == true || Auth::User()->userGroup == 1)
													<a href="{!! URL::to('admin/customer/modify/'.$customer->id) !!}">
														<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
													</a>
												@endif

												@if($deletePermission == true || Auth::User()->userGroup == 1)
													<button type="button" class="btn btn-icon-toggle customerDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="{!! $customer->id !!}"><i class="fa fa-trash-o"></i></button>
												@endif
											</td>
										</tr>
									<?php $i++; ?>
									@endforeach
								</tbody>
							</table>
							Showing {!! $customers->firstItem() !!} to {!! $customers ->lastItem() !!} of {!! $customers->total() !!}
						</div><!--end .table-responsive -->
					</div><!--end .col -->
					<div class="col-lg-12">
						<div class="btn-group pull-right">
						<?php echo $customers->render();  ?> </div></div>
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js') !!}
	{!! HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js') !!}
	{!! HTML::script('backend/js/mani.js') !!}
	<script type="text/javascript">
		$(document).ready(function(){
	    	//$('#myTable').DataTable();
	    	//$(".dataTables_info").hide();
	    	//$(".paginate_button").hide();
		});
	</script>
@stop