<?php 
	use App\Models\User; 
	use App\Models\Generalsetting; 
	use App\Models\Option; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Customers</li>
					<li class="active">Modify</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Modify Customers</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/customers","Manage Customers",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/customer/modify/".$customer->id,"class"=>"form"]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Modify Customer</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									<div class="row">
										<div class="col-sm-6">
											<div class="form-group @if($errors->has('firstName'))has-error @endif">
												{!! Form::text("firstName",$customer->firstName,["class"=>"form-control"]) !!}
													@if($errors->has("firstName"))
														<span id="firstName-error" class="help-block">{!! $errors->first("firstName") !!}</span>
													@endif
												{!! HTML::decode(Form::label("firstName","First Name")) !!}
											</div>
										</div>
										<div class="col-sm-6">
											<div class="form-group @if($errors->has('lastName'))has-error @endif">
												{!! Form::text("lastName",$customer->lastName,["class"=>"form-control"]) !!}
													@if($errors->has("lastName"))
														<span id="lastName-error" class="help-block">{!! $errors->first("lastName") !!}</span>
													@endif
												{!! HTML::decode(Form::label("lastName","Last Name")) !!}
											</div>
										</div>
									</div>

									<div class="form-group">
										{!! Form::text("email",$customer->email,["class"=>"form-control",'disabled']) !!}
										{!! HTML::decode(Form::label("email","Email")) !!}
									</div>

									<div class="form-group @if($errors->has('phone'))has-error @endif">
									{!! Form::text("phone",$customer->phone,["class"=>"form-control"]) !!}
											@if($errors->has("phone"))
												<span id="phone-error" class="help-block">{!! $errors->first("phone") !!}</span>
											@endif
											{!! HTML::decode(Form::label("phone","Phone")) !!}
									</div>

									<div class="form-group @if($errors->has('gender'))has-error @endif">
									{!! Form::select("gender",[""=>"Select Gender",'Male'=>"Male",'Female'=>"Female"],$customer->gender,["class"=>"form-control"]) !!}
											@if($errors->has("gender"))
												<span id="gender-error" class="help-block">{!! $errors->first("gender") !!}</span>
											@endif
											{!! HTML::decode(Form::label("gender","Gender")) !!}
									</div>

									<div class="form-group @if($errors->has('address'))has-error @endif">
										{!! Form::textarea("address",$customer->address,["class"=>"form-control"]) !!}
										{!! HTML::decode(Form::label("address","Address")) !!}
									</div>

									<div class="form-group">
										{!! Form::text("landmark",$customer->landmark,["class"=>"form-control"]) !!}
										{!! HTML::decode(Form::label("landmark","Landmark")) !!}
									</div>

									<div class="form-group">
										{!! Form::text("city",$customer->city,["class"=>"form-control"]) !!}
										{!! HTML::decode(Form::label("city","City")) !!}
									</div>
									<?php
				                    	$stateList = DB::table('state')->pluck('state','id');
				                    ?>
									<div class="form-group">
										{!! Form::select("state",$stateList,$customer->state,["class"=>"form-control", 'placeholder' => 'Select State']) !!}
										{!! HTML::decode(Form::label("state","State")) !!}
									</div>

									<div class="form-group">
										{!! Form::text("pincode",$customer->pincode,["class"=>"form-control"]) !!}
										{!! HTML::decode(Form::label("pincode","Pincode")) !!}
									</div>

									<div class="form-group @if($errors->has('dob'))has-error @endif">
									{!! Form::text("dob",$customer->dob,["class"=>"form-control",'id'=>'dob']) !!}
											@if($errors->has("dob"))
												<span id="dob-error" class="help-block">{!! $errors->first("dob") !!}</span>
											@endif
											{!! HTML::decode(Form::label("dob","DOB")) !!}
									</div>

									

								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Modify Customer</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
{!!HTML::script('backend/js/mani.js')!!}
{!!HTML::script('backend/assets/js/libs/bootstrap-datepicker/bootstrap-datepicker.js')!!}
<script>
  $(function() {
    $( "#dob" ).datepicker({
      changeMonth: true,
      changeYear: true,
      format:"yyyy-mm-dd",
      endDate: '+0d',
    });
   });
  </script>
@stop