<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>
@extends("backend/master")
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css')!!}
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Users</li>
					<li>Sellers</li>
				</ol>
			</div>
			<div class="section-header">
				<div class="row">
					<div class="col-lg-6">
						<h2 class="text-primary">List of Sellers</h2>
					</div>
					<div class="col-lg-6">
						{!! HTML::link("admin/users/sellers/add","Add New Seller",["class"=>"btn ink-reaction pull-right btn-primary"]) !!}
					</div>
				</div>
			</div>

			<div class="section-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Name</th>
										<th>Company</th>
										<th>Email</th>
										<th>Created On</th>
										<th>Last Login</th>
										<th>IP Address</th>
										<th>Status</th>
										<th>Actions</th>
									</tr>
								</thead>
								<tbody>
								@if(count($sellers)>0)
									<?php $i=0; ?>
									@foreach($sellers as $seller)
									<td>{!! ++$i !!}</td>
									<td>{!! $seller->firstName." ".$seller->lastName!!}</td>
									<td>{!! $seller->companyName !!}</td>
									<td>{!! $seller->email !!}</td>
									<td>{!! date('Y-m-d h:i A',strtotime($seller->created_at)) !!}</td>
									<td>{!! $seller->lastLogin !!}</td>
									<td>{!! $seller->ipAddress !!}</td>
									@if($seller->status=='active')
									<td><button type="button" class="btn ink-reaction btn-xs btn-success sellerStatus" data-id="{!! $seller->sellerId!!}">Active</button></td>
									@else
									<td><button type="button" class="btn ink-reaction btn-xs sellerStatus btn-danger" data-id="{!! $seller->sellerId!!}">Inactive</button></td>
									@endif
									
									<td>
											<a href="{!! URL::to('admin/users/sellers/modify/'.$seller->sellerId)!!}">
											<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
											</a>
											<button type="button" class="btn btn-icon-toggle sellerDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="{!! $seller->sellerId!!}"><i class="fa fa-trash-o"></i></button>
											</td>
											</tr>
									@endforeach
								@else
								No sellers available.
								@endif
									
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!!HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js')!!}
	{!!HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js')!!}
	{!!HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js')!!}
	{!!HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js')!!}
	<script type="text/javascript">
	$(document).ready(function(){
    	$('#myTable').DataTable();
	});

	$(document).on("click",".sellerStatus",function(){
		var clicked=$(this);
		var id=clicked.attr("data-id");
		// if(confirm("Do you really want to change this currency status?")==false){
		// 	return false;
		// }
		$.ajax({
			type: "POST",
			url: "/admin/users/sellers/status",
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
			data:{id},
			dataType: "json",
			success: function(data){
				console.log(data);
				var colour="";
				if(data.status=="success"){
					data.current=="Inactive"?colour="btn-danger":colour="btn-success";
					clicked.text(data.current);
					clicked.removeClass("btn-success btn-danger").addClass(colour);
					success_msg(data.msg);
				}
				return false;
			},
			error: function(e){
				console.log(e.responseText);
				return false;
			}
		});/* end of ajax function*/
	});/* end of click function */

	$(document).on("click",".sellerDelete",function(){
		var clicked=$(this);
		var id=clicked.attr("data-id");
		// if(confirm("Do you really want to delete this currency?")==false){
		// 	return false;
		// }
		$.ajax({
			type: "POST",
			url: "/admin/users/sellers/delete",
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
			data: {id},
			dataType: "json",
			success: function(data){
				console.log(data);
				var colour="";
				if(data.status=="success"){
					clicked.closest("tr").hide();
					success_msg(data.msg);
				}
				return false;
			},
			error: function(e){
				console.log(e.responseText);
				return false;
			}
		});/* end of ajax */
		return false;
	});/* end of click function */
	</script>
@stop