<?php 
	use App\Models\Currency; 
?>
@extends("backend/master")
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css')!!}
@stop
@section('maincontent')


	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Users</li>
					<li>User Roles</li>
				</ol>
			</div>
			<div class="section-header">
				<div class="row">
					<div class="col-lg-6">
						<h2 class="text-primary">User Roles</h2>
					</div>
					<div class="col-lg-6">
						{!! HTML::link("admin/users/role/add","Add New User Role",["class"=>"btn ink-reaction pull-right btn-primary"]) !!}
					</div>
				</div>
			</div>
			<div class="section-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Name</th>
										<th class="sort-numeric">Status</th>
										<th class="sort-alpha">Actions</th>
									</tr>
								</thead>
								<tbody>
									<?php $i=1; ?>
									@foreach($roles as $role)
										<tr class="gradeX">
											<td>{!! $i !!}</td>
											<td>{!! $role->name !!}</td>
											<?php
												$role->status == "active" ? $class = "success" : $class = "danger";
											?>
											@if($role->id != 1 && Auth::User()->userGroup < $role->id)
												<td><button type="button" class="btn ink-reaction btn-xs btn-{!! $class !!} roleStatus" data-id="{!! $role->id !!}">{!! ucfirst($role->status) !!}</button></td>
											@else
								              <td></td>
								            @endif

											<td>
												@if($role->id != 1 && Auth::User()->userGroup < $role->id)
													<a href="{!! URL::to('admin/users/role/modify/'.$role->id) !!}">
														<button type="button" class="btn btn-icon-toggle ink-reaction" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
													</a>
												@endif

												@if($role->id != 1 && Auth::User()->userGroup < $role->id)
													<button type="button" class="btn btn-icon-toggle ink-reaction roleDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="{!! $role->id !!}"><i class="fa fa-trash-o"></i></button>
												@endif
											</td>
										</tr>
									<?php $i++; ?>
									@endforeach
									
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!!HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js')!!}
	{!!HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js')!!}
	{!!HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js')!!}
	{!!HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js')!!}
	{!!HTML::script('backend/js/adminmenu.js')!!}
	<script type="text/javascript">
	$(document).ready(function(){
    	$('#myTable').DataTable();
	});

	$(document).on("click",".roleStatus",function()
	{
		var clicked=$(this);
		var id=clicked.attr("data-id");
		swal({
	        title: "Are you sure?",
	        text: "Do you really want to change the user role status?",
	        type: "warning",
	        showCancelButton: true,
	        confirmButtonColor: "#EE2C47",
	        confirmButtonText: "Yes, change it!",
	        cancelButtonText: "No, cancel pls!",
	        closeOnConfirm: false,
	        closeOnCancel: false
	    },
	    function(isConfirm)
	    {
	        if (!isConfirm) 
	        {
	          swal("Cancelled", "user role status is not being changed :)", "error");
	          return false;
	        } 
			clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');
			$.ajax({
				type: "POST",
				url: "/admin/users/role/status",
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
				data:{id},
				dataType: "json",
				success: function(data){
					console.log(data);
					var colour="";
					if(data.status=="success"){
						data.current=="Inactive"?colour="btn-danger":colour="btn-success";
						clicked.text(data.current);
						clicked.removeClass("btn-success btn-danger").addClass(colour);
						$("#processingIcon").remove();
						swal("Changed!", "User role status changed to "+data.current, "success");
						success_msg(data.msg);
					}
					return false;
				},
				error: function(e){
					console.log(e.responseText);
					return false;
				}
			});/* end of ajax function*/
		});/* end of confirm function */
		return false;
	});/* end of click function */

	$(document).on("click",".roleDelete",function()
	{
		var clicked=$(this);
		var id=clicked.attr("data-id");
		swal({
	            title: "Are you sure?",
	            text: "Do you really want to delete this user role?",
	            type: "warning",
	            showCancelButton: true,
	            confirmButtonColor: "#EE2C47",
	            confirmButtonText: "Yes, delete!",
	            cancelButtonText: "No, cancel pls!",
	            closeOnConfirm: false,
	            closeOnCancel: false
        	},
          	function(isConfirm)
          	{
            	if(!isConfirm) 
            	{
              		swal("Cancelled", "User role is not being deleted :)", "error");
              		$("#processingIcon").remove();
              		return false;
            	}
            	clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');
				$.ajax({
					type: "POST",
					url: "/admin/users/role/delete",
					headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
					data: {id},
					dataType: "json",
					success: function(data){
						console.log(data);
						var colour="";
						if(data.status=="success"){
							clicked.closest("tr").hide();
							success_msg(data.msg);
							$("#processingIcon").remove();
							swal("Deleted!", "User role deleted successfully :)", "success");
						}
						return false;
					},
					error: function(e){
						console.log(e.responseText);
						return false;
					}
				});/* end of ajax */
			});/* end of confirm function */
		return false;
	});/* end of click function */


	</script>
@stop