<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Usergroup; 

	$updatePermission = Usergroup::getupdatepermission(Auth::User()->userGroup, 11);
	$deletePermission = Usergroup::getdeletepermission(Auth::User()->userGroup, 11);
	$addPermission = Usergroup::getupdatepermission(Auth::User()->userGroup, 11);
?>
@extends("backend/master")
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css')!!}
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Admin Members</li>
				</ol>
			</div>
			<div class="section-header">
				<div class="row">
					<div class="col-lg-6">
						<h2 class="text-primary">List of Admin Members</h2>
					</div>
					@if($addPermission == true || Auth::User()->userGroup == 1)
						<div class="col-lg-6">
							{!! HTML::link("admin/users/add","Add New Admin Member",["class"=>"btn ink-reaction pull-right btn-primary"]) !!}
						</div>
					@endif
				</div>
			</div>



			<div class="section-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Name</th>
										<th>Email</th>
										<th>Created On</th>
										<th>Last Login</th>
										<th>IP Address</th>
										<th class="sort-numeric">Status</th>
										@if(($updatePermission == true || $deletePermission == true || Auth::User()->userGroup == 1))
											<th class="sort-alpha">Actions</th>
										@endif
									</tr>
								</thead>
								<tbody>
									<?php $i = 1; ?>
									@foreach($users as $user)
										<tr class="gradeX">
											<td>{!! $i !!}</td>
											<td>{!! $user->firstName.$user->lastName !!}</td>
											<td>{!! $user->email !!}</td>
											<td>{!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($user->created_at)) !!}</td>
											<td>{!! $user->lastLogin != "" ? date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($user->lastLogin)) : "" !!} </td>
											<td>{!! $user->ipAddress !!}</td>
											<?php
												$user->status=="active"?$class="success":$class="danger";
											?>
											<td><button type="button" class="btn ink-reaction btn-xs btn-{!! $class !!} userStatus" data-id="{!! $user->id !!}">{!! ucfirst($user->status) !!}</button></td>
											<td>
												@if($updatePermission == true || Auth::User()->userGroup == 1)
													<a href="{!! URL::to('admin/users/modify/'.$user->id) !!}">
														<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
													</a>
												@endif

												@if($deletePermission == true || Auth::User()->userGroup == 1)
													<button type="button" class="btn btn-icon-toggle userDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="{!! $user->id !!}"><i class="fa fa-trash-o"></i></button>
												@endif
											</td>
										</tr>
									<?php $i++; ?>
									@endforeach
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js') !!}
	{!! HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js') !!}
	{!! HTML::script('backend/js/bala.js') !!}
	<script type="text/javascript">
	$(document).ready(function(){
    	$('#myTable').DataTable();
	});
	</script>
@stop