<?php
    use App\Models\CustomPages; 
    use App\Models\Option;
?>
@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>{!! CustomPages::getcontent("aboutUsPageTitle") !!}</h1>
                <ol class="breadcrumb">
                    <li><a href="{!!URL::to('')!!}">Home</a></li>
                    <li>{!! CustomPages::getcontent("aboutUsPageTitle") !!}</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-md-5 text-justify">
                        {!! CustomPages::getcontent("aboutUsDetailsOne") !!}
                    </div>
                    <div class="col-md-7">
                        {!! CustomPages::getcontent("aboutUsDetailsTwo") !!}
                    </div>
                </div>
            </div>

            <div class="spacer-40"></div>

            <div class="padding-tb45 bg-color2">
                <div class="container">
                    <div class="row">
                        <div class="col-md-8 col-md-offset-2">
                            <div class="text-align-center">
                                <h3 class="margin-0">{!! CustomPages::getcontent("aboutUsShortDescription") !!}</h3>
                                <hr class="sm">
                                {!! CustomPages::getcontent("aboutUsWidgetTwoDescription") !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="arrow-upwards"><i class="fa fa-angle-down"></i></div>

            <div class="container">
                <ul class="timeline">
                    <li>
                        <div class="timeline-badge">{!! CustomPages::getcontent("acmYear1") !!}</div>
                        <div class="timeline-panel">
                            <div class="timeline-body">
                                <p>{!! CustomPages::getcontent("acmActivity1") !!}</p>
                            </div>
                        </div>
                    </li>
                    <li class="timeline-inverted">
                        <div class="timeline-badge">{!! CustomPages::getcontent("acmYear2") !!}</div>
                        <div class="timeline-panel">
                            <div class="timeline-body">
                                <p>{!! CustomPages::getcontent("acmActivity2") !!}</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="timeline-badge">{!! CustomPages::getcontent("acmYear3") !!}</div>
                        <div class="timeline-panel">
                            <div class="timeline-body">
                                <p>{!! CustomPages::getcontent("acmActivity3") !!}</p>
                            </div>
                        </div>
                    </li>
                    <li class="timeline-inverted">
                        <div class="timeline-badge">{!! CustomPages::getcontent("acmYear4") !!}</div>
                        <div class="timeline-panel">
                            <div class="timeline-body">
                                <p>{!! CustomPages::getcontent("acmActivity4") !!}</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="timeline-badge">{!! CustomPages::getcontent("acmYear5") !!}</div>
                        <div class="timeline-panel">
                            <div class="timeline-body">
                                <p>{!! CustomPages::getcontent("acmActivity5") !!}</p>
                            </div>
                        </div>
                    </li>
                    <li class="timeline-inverted">
                        <div class="timeline-badge">{!! CustomPages::getcontent("acmYear6") !!}</div>
                        <div class="timeline-panel">
                            <div class="timeline-body">
                                <p>{!! CustomPages::getcontent("acmActivity6") !!}</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="timeline-badge">{!! CustomPages::getcontent("acmYear7") !!}</div>
                        <div class="timeline-panel">
                            <div class="timeline-body">
                                <p>{!! CustomPages::getcontent("acmActivity7") !!}</p>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
@stop