<?php
    use App\Models\CustomPages;
?>
@extends('frontend/master')
@section('styles')
    {!! RecaptchaV3::initJs() !!}
@endsection
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>{!! CustomPages::getcontent("contactUsPageTitle") !!}</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li>{!! CustomPages::getcontent("contactUsPageTitle") !!}</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-md-7">
                        <h4 class="widgettitle">Request Information</h4>
                        @if(Session::has('success'))
                            <div class="alert alert-success">{{ Session::get('success') }}</div>
                        @endif
                        @if ($errors->has('g-recaptcha-response'))
                            <div class="alert alert-danger">Recaptcha failed. Please refresh and try again.</div>
                        @endif
                        <form method="post" action="{{ url('/contact/post') }}" class="clearfix">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 col-sm-6">
                                    <label>Full Name <span class="req">*</span></label>
                                    <input type="text" id="name" name="name" class="form-control input-lg">
                                    @if($errors->has("name"))
                                        <span class="required">{!! $errors->first("name") !!}</span>
                                   @endif
                                </div>
                                <div class="col-md-6 col-sm-6">
                                    <label>Company Name</label>
                                    <input type="text" id="company_name" name="company_name" class="form-control input-lg">
                                    @if($errors->has("company_name"))
                                        <span class="required">{!! $errors->first("company_name") !!}</span>
                                   @endif
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-sm-6">
                                    <label>Email ID <span class="req">*</span></label>
                                    <input type="text" id="email" name="email" class="form-control input-lg">
                                    @if($errors->has("email"))
                                        <span class="required">{!! $errors->first("email") !!}</span>
                                   @endif
                                </div>
                                <div class="col-md-6 col-sm-6">
                                    <label>Contact Number <span class="req">*</span></label>
                                    <input type="text" id="contact_number" name="contact_number" class="form-control input-lg">
                                    @if($errors->has("contact_number"))
                                        <span class="required">{!! $errors->first("contact_number") !!}</span>
                                   @endif
                                </div>
                            </div>

                            <label>Message <span class="req">*</span></label>
                            <textarea class="form-control input-lg" id="comments" name="comments" rows="6"></textarea>
                            @if($errors->has("comments"))
                                <span class="required">{!! $errors->first("comments") !!}</span>
                           @endif

                            <div class="form-group{{ $errors->has('g-recaptcha-response') ? ' has-error' : '' }}">
                                <div class="col-md-6">
                                    {!! RecaptchaV3::field('register') !!}
                                </div>
                            </div>

                            <div class="spacer-10"></div>

                            <div class="clearfix">
                                <button type="submit" name="submit" class="btn btn-primary btn-lg">Submit</button>
                            </div>

                        </form>
                    </div>
                    <div class="col-md-4 col-md-offset-1">
                        <h4 class="widgettitle">Get in touch with us</h4>
                        <h4 class="accent-color"><b>ADVERTISING CLUB MADRAS</b></h4>
                        <p>
                            {!! CustomPages::getcontent("contactUsAddress") !!}<br><br>
                            <b>Phone:</b> {!! CustomPages::getcontent("contactUsPhone") !!}<br>
                            <!--<b>Fax:</b> {!! CustomPages::getcontent("contactUsFax") !!}<br>-->
                            <b>Email:</b> 
                            <?php
                                $emails = CustomPages::getcontent("contactUsEmail");
                                $emailArray = explode(",", $emails);
                                $i = 0;
                            ?>

                            @foreach($emailArray as $array)
                                @if($i > 0) , @endif
                                <a href="mailto:{!! $array !!}">{!! $array !!}</a>
                            @endforeach
                        </p>

                        <p>
                            <b>PAN No.:</b> AAAAA5944J<br>
                            <b>GST No.:</b> 33AAAAA5944J1ZV
                        </p>
                    </div>
                </div>
            </div>
        </div>

        {!! CustomPages::getcontent("contactUsMap") !!}
    </div>
@stop

@section('script')
    <!-- <script src="https://www.google.com/recaptcha/api.js?render=reCAPTCHA_site_key"></script> -->

@endsection