@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Course Application</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li><a href="{!! URL::to('course-offered') !!}">Course Offered</a></li>
                    <li>Course Application</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="col-md-2 col-sm-12">
                    @include('frontend/course-sidebar')
                </div>

                <div class="col-md-10">
                    @if(Session::has("success"))
                        <div class="alert alert-success">
                            <p><b>Your Application Submitted Sucessfully.!</b><br/>
                              Thank you for applying with Advertising Club Madras <br/>
                              Our team member will contact you soon<br/>
                            </p>
                        </div>
                    @endif

                    @if(Auth::check())
                        <h5 class="subhead">A career-oriented program</h5>
                        <h3 class="accent-color">Post Graduate Diploma Advertising Management</h3>
                        {!! Form::open([ "method"=>"post", "files"=>true, "enctype"=>"multipart/form-data", "id"=>"courseApplicationForm"]) !!}
                            {!! csrf_field() !!}
                            <div class="row">
                                <div class="col-md-6 col-sm-6">
                                    {!! HTML::decode(Form::label("name", "Full Name <span class='required'>*</span>", ["class"=>""])) !!}
                                    {!! Form::text("name", "", ["class"=>"form-control input-lg"]) !!}
                                    @if($errors->has("name"))
                                        <span class="required">{!! $errors->first("name") !!}</span>
                                    @endif
                                </div>

                                <div class="col-md-6 col-sm-6">
                                    {!! HTML::decode(Form::label("father_name", "Father's/Husband's Name <span class='required'>*</span>", ["class"=>""])) !!}
                                    {!! Form::text("father_name", "", ["class"=>"form-control input-lg"]) !!}
                                    @if($errors->has("father_name"))
                                        <span class="required">{!! $errors->first("father_name") !!}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-sm-6">
                                    {!! HTML::decode(Form::label("address1", "Permanent Address <span class='required'>*</span>", ["class"=>""])) !!}
                                    {!! Form::textarea("address1", "", ["class"=>"form-control input-lg", "rows"=>4]) !!}
                                    @if($errors->has("address1"))
                                        <span class="required">{!! $errors->first("address1") !!}</span>
                                    @endif
                                </div>

                                <div class="col-md-6 col-sm-6">
                                    {!! HTML::decode(Form::label("address2", "Address for Correspondence <span class='required'>*</span>", ["class"=>""])) !!}
                                    {!! Form::textarea("address2", "", ["class"=>"form-control input-lg", "rows"=>4]) !!}
                                    @if($errors->has("address2"))
                                        <span class="required">{!! $errors->first("address2") !!}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-sm-6">
                                    {!! HTML::decode(Form::label("dob", "Date of Birth <span class='required'>*</span>", ["class"=>""])) !!}
                                    {!! Form::text("dob", "", ["class"=>"form-control input-lg", 'id'=>'dob']) !!}
                                    @if($errors->has("dob"))
                                        <span class="required">{!! $errors->first("dob") !!}</span>
                                    @endif
                                </div>

                                <div class="col-md-6 col-sm-6">
                                    <label></label>
                                    {!! HTML::decode(Form::label("phone", "Phone Number <span class='required'>*</span>", ["class"=>""])) !!}
                                    {!! Form::text("phone", "", ["class"=>"form-control input-lg"]) !!}
                                    @if($errors->has("phone"))
                                        <span class="required">{!! $errors->first("phone") !!}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-sm-6">
                                    {!! HTML::decode(Form::label("mobile", "Mobile Number <span class='required'>*</span>", ["class"=>""])) !!}
                                    {!! Form::text("mobile", "", ["class"=>"form-control input-lg"]) !!}
                                    @if($errors->has("mobile"))
                                        <span class="required">{!! $errors->first("mobile") !!}</span>
                                    @endif
                                </div>

                                <div class="col-md-6 col-sm-6">
                                    {!! HTML::decode(Form::label("emailid", "Email ID <span class='required'>*</span>", ["class"=>""])) !!}
                                    {!! Form::email("emailid", "", ["class"=>"form-control input-lg"]) !!}
                                    @if($errors->has("emailid"))
                                        <span class="required">{!! $errors->first("emailid") !!}</span>
                                    @endif
                                </div>
                            </div>

                            <hr class="fw">

                            <div class="row">
                                <div class="col-md-12">
                                    <h4 class="margin-5"><b>Educational Qualification</b> <span class="required">*</span></h4>
                                    <table class="table table-bordered edu-qua">
                                        <thead>
                                            <tr>
                                                <th><b>Year</b></th>
                                                <th><b>School/College</b></th>
                                                <th><b>University</b></th>
                                                <th><b>Degree</b></th>
                                                <th><b>Marks/Class</b></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="educationCount" id="educationCount1">
                                                <td>{!! Form::text("year0", "", ["class"=>"form-control input-lg", "id"=>"year0"]) !!}</td>
                                                <td>{!! Form::text("school0", "", ["class"=>"form-control input-lg", "id"=>"school0"]) !!}</td>
                                                <td>{!! Form::text("university0", "", ["class"=>"form-control input-lg", "id"=>"university0"]) !!}</td>
                                                <td>{!! Form::text("degree0", "", ["class"=>"form-control input-lg", "id"=>"degree0"]) !!}</td>
                                                <td>{!! Form::text("mark0", "", ["class"=>"form-control input-lg", "id"=>"mark0"]) !!}</td>
                                            </tr>

                                            {!! Form::hidden("educationLength", 1, ["id"=>"educationLength"]) !!}
                                            
                                            <tr>
                                                <td colspan="5">
                                                    <button class="btn btn-primary btn-sm" id="addNewEducationRecord" type="button">Add New Record &nbsp;<i class="fa fa-plus-circle"></i></button>
                                                    <button class="btn btn-danger btn-sm" id="removeNewEducationRecord" type="button">Remove Previous Record &nbsp;<i class="fa fa-minus-circle"></i></button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <hr class="fw">

                                    <h4 class="margin-5"><b> Work Experience</b></h4>
                                    <table class="table table-bordered edu-qua">
                                        <thead>
                                            <tr>
                                                <th><b>Period</b></th>
                                                <th><b>Organisation</b></th>
                                                <th><b>Designation</b></th>
                                                <th><b>Nature of Work</b></th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            <tr class="experienceCount" id="experienceCount1">
                                                <td>{!! Form::text("period0", "", ["class"=>"form-control input-lg workExperienceFields", "id"=>"period0"]) !!}</td>
                                                <td>{!! Form::text("organisation0", "", ["class"=>"form-control input-lg workExperienceFields", "id"=>"organisation0"]) !!}</td>
                                                <td>{!! Form::text("designation0", "", ["class"=>"form-control input-lg workExperienceFields", "id"=>"designation0"]) !!}</td>
                                                <td>{!! Form::text("work0", "", ["class"=>"form-control input-lg workExperienceFields", "id"=>"work0"]) !!}</td>
                                            </tr>

                                            {!! Form::hidden("experienceLength", 1, ["id"=>"experienceLength"]) !!}

                                            <tr>
                                                <td colspan="4">
                                                    <button class="btn btn-primary btn-sm" id="addNewExperienceRecord" type="button">Add New Record &nbsp;<i class="fa fa-plus-circle"></i></button>
                                                    <button class="btn btn-danger btn-sm"  id="removeNewExperienceRecord" type="button">Remove Previous Record &nbsp;<i class="fa fa-minus-circle"></i></button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    {!! HTML::decode(Form::label("photo", "Upload Photo <span class='required'>*</span>", ["class"=>""])) !!}
                                    {!! Form::file("photo", ["class"=>"", "id"=>"photo"]) !!}
                                    @if($errors->has("photo"))
                                        <span class="required">{!! $errors->first("photo") !!}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="spacer-20"></div>

                            <div class="row">
                                <div class="col-md-12">
                                    {!! HTML::decode(Form::label("comment", 'Please answer in less than 100 words "Why I want to join this course?" <span class="required">*</span>', ["class"=>""])) !!}
                                    {!! Form::textarea("comment", "", ["class"=>"form-control input-lg", "rows"=>6]) !!}
                                    @if($errors->has("comment"))
                                        <span class="required">{!! $errors->first("comment") !!}</span>
                                    @endif
                                    
                                    <div class="row">
                                        <div class="col-md-4 col-sm-4">
                                            <label>
                                                {!! Form::radio("paymentType", "offline", "", ["class"=>"option-input radio", "id"=>"paymentType"]) !!}
                                                Off-Line Payment
                                            </label>
                                        </div>

                                        <div class="col-md-4 col-sm-4">
                                            <label>
                                                {!! Form::radio("paymentType", "online", "", ["class"=>"option-input radio", "id"=>"paymentType"]) !!}
                                                On-Line Payment
                                            </label>
                                        </div>
                                    </div><!--end row-->

                                    <div class="clearfix"></div>
                                    <br>
                                    <label>
                                        {!! Form::checkbox("termsAndConditions", "agreed", true, ["class"=>"option-input checkbox termsAndConditions", "id"=>"termsAndConditions"]) !!}
                                        I agree to the <a href="">Terms and Conditions</a> of Advertisement club Madras
                                    </label>

                                    <br>

                                    <div class="spacer-40"></div>

                                    <div class="clearfix">
                                        {!! Form::submit("Submit", ["class"=>"btn btn-primary btn-lg", "id"=>"submitCourseApplication"]) !!}
                                    </div>
                                </div>
                            </div>
                        {!! Form::close() !!}
                    @else
                        <div class="col-md-10 col-md-offset-1">
                        <div class="text-center">
                           <p>We hereby apply for Course to <b>THE ADVERTISING CLUB MADRAS</b> , if selected we will be goverened by<br>
                            The By – Laws and rules and regulations of the club . “ Annual Subscription ‘’ </p>

                            <hr>

                            <h3 class="margin-0">Please login to submit your application</h3>
                            <hr class="alt">

                            <div><a href="{!! URL::to('login') !!}" class="btn ink-reaction btn-bg btn-danger">Apply Now</a></div>

                            <hr>
                            
                        </div>

                        
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div id="hiddenForm" style="display: none;"></div>
@stop

@section("script")
    {!! HTML::script('frontend/js/jquery-ui.js') !!}
    {!! HTML::style('frontend/css/jquery-ui.css') !!}
    <script>
        $("#dob").datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat:'yy-mm-dd',
            yearRange: '1900:'+(new Date).getFullYear(),
            numberOfMonths: 1,
        });

        $("#removeNewEducationRecord").hide();
        $("#removeNewExperienceRecord").hide();

        $(document).on("click", "#addNewEducationRecord", function(){
            var length = $(".educationCount").length;
            var row = parseInt(length) + parseInt(1);

            //Append Code
            var req_code = '';
            req_code += '<tr class="educationCount" id="educationCount'+row+'">';
            req_code += '<td><input class="form-control input-lg" id="year'+length+'" name="year'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="school'+length+'" name="school'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="university'+length+'" name="university'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="degree'+length+'" name="degree'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="mark'+length+'" name="mark'+length+'" value="" type="text"></td>';
            req_code += '</tr>';
            $(req_code).insertAfter("#educationCount"+length);

            $("#educationLength").val(row);

            if(length >= 1){
                $("#removeNewEducationRecord").show();
            }
        });

        $(document).on("click", "#removeNewEducationRecord", function(){
            var length = $(".educationCount").length;
            if(length != 1){
                $("#educationCount"+length).remove();
            }

            if(length == 2){
                $("#removeNewEducationRecord").hide();
            }

            $("#educationLength").val(parseInt(length) - parseInt(1));
        });

        $(document).on("click", "#addNewExperienceRecord", function(){
            var length = $(".experienceCount").length;
            var row = parseInt(length) + parseInt(1);

            //Append Code
            var req_code = '';
            req_code += '<tr class="experienceCount" id="experienceCount'+row+'">';
            req_code += '<td><input class="form-control input-lg" id="period'+length+'" name="period'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="organisation'+length+'" name="organisation'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="designation'+length+'" name="designation'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="work'+length+'" name="work'+length+'" value="" type="text"></td>';
            req_code += '</tr>';
            $(req_code).insertAfter("#experienceCount"+length);

            //var clone = $("#experienceCount"+length).clone().attr("id", "experienceCount"+row).insertAfter("#experienceCount"+length).find('input, textarea').val('');
            if(length >= 1){
                $("#removeNewExperienceRecord").show();
            }

            $("#experienceLength").val(row);
        });

        $(document).on("click", "#removeNewExperienceRecord", function(){
            var length = $(".experienceCount").length;
            if(length > 1){
                $("#experienceCount"+length).remove();
            }

            if(length == 2){
                $("#removeNewExperienceRecord").hide();
            }

            $("#experienceLength").val(parseInt(length) - parseInt(1));
        });


        $('#courseApplicationForm').submit(function(e) {
            e.preventDefault();
            var t = $('#submitCourseApplication'); $('.validate').remove(); $('.smsg').remove();
            $(".validation_msg").remove();

            if(!$("#termsAndConditions").is(':checked')){
                swal("Agree", "Please agree to our terms and conditions", "info");
                return false;
            }

            if(!$("input[name='paymentType']").is(':checked')){
                swal("Please Select", "Please select payment type", "info");
                return false;
            }

            var error = "no";
            $("form :input").each(function(){
                var currentField = $(this);
                var fieldid = $(this).attr('id');
                var fieldvalue = $(this).val();
                if(fieldid != "addNewEducationRecord" && fieldid != "removeNewEducationRecord" && fieldid != "addNewExperienceRecord" && fieldid != "removeNewExperienceRecord" && fieldid != "clickModifyAppliedCourse" && fieldid != "photo" && fieldid != "paymentType" && fieldid != "paymentType"){
                    if(fieldvalue == '' || fieldvalue == null){

                       if(currentField.hasClass('workExperienceFields') == false){
                            $('#'+fieldid).after("<div class='validation_msg'>Don't leave this field empty.</div>").focus();
                            $('html, body').animate({
                                scrollTop: $("#"+fieldid).parent().position().top
                            }, 1000);
                            error = "yes";
                            return false;
                       }
                    }
                }

                if(fieldid == 'phone' || fieldid == 'mobile'){
                   var mob_num = $('#'+fieldid).val();
                    var filter = /^[0-9-+ ]+$/ ;
                    if (!filter.test(mob_num)) {
                        $('#'+fieldid).after("<div class='mobileno_msg'>Please enter valid "+fieldid+" number.</div>").focus();
                        $('html, body').animate({
                                scrollTop: $("#"+fieldid).parent().position().top
                            }, 1000);
                        error = "mobile";
                        return false;
                    }
                }
            });
            
            if(error == "yes"){
                return false;
            }
            
            if(error ==  "mobile"){
                return false;
            }
            var txt = t.text();
            let formData = new FormData(this);
            t.text('Procssing...').prop( "disabled", true );
            $.ajax({
                contentType: false,
                processData: false,
                type: "POST",
                url:  "{{route('course.application.post')}}",
                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
                data: formData,
                dataType: "json",
                success: function(data){
                    if(data.status == "success"){
                       if(data.type == 'online'){
                         $('#hiddenForm').html(data.template);
                         $('#hiddenFormBox').submit();
                       }else{
                         window.location.href = data.url;
                       }
                    }else if(data.status == "validation"){
                        t.text(txt).prop( "disabled", false );
                        $.each(data.validation, function(k,v){
                            k = k.split('.')[0];
                            $('#'+k).after('<span class="validate" style="color:red;">'+v+'</span>');
                        });
                    }else{
                         t.text(txt).prop( "disabled", false );
                         alert(data.msg);
                    }
                    return false;
                },
                error: function(e){
                    t.text(txt).prop( "disabled", false );
                    alert('Error. Please try again');
                    return false;
                }
            });/* end of ajax */

        });

    </script>
@stop