<?php 
    use App\Models\CustomPages; 
    use App\Models\Option; 
?>
@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>{!! CustomPages::getcontent("courseOfferedPageTitle") !!}</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li>{!! CustomPages::getcontent("courseOfferedPageTitle") !!}</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40 past-presidents">
            <div class="container">
                <div class="col-md-2 col-sm-12 parallax">
                    @include('frontend/course-sidebar')
                </div>

                <div class="col-md-10">
                    <h5 class="subhead">{!! CustomPages::getcontent("courseOfferedSubTitle") !!}</h5>
                    <h3 class="accent-color">{!! CustomPages::getcontent("courseOfferedWidgetOneTitle") !!}</h3>

                    <div class="row">
                        <div class="col-md-5">
                            <div class="text-justify">
                                <img src="{!!URL::asset('frontend/images/pgdam.jpg')!!}" class="img-responsive">
                                <!--{!! CustomPages::getcontent("courseOfferedWidgetOneTextOne") !!}-->
                            </div>
                        </div>

                        <div class="col-md-7">
                            <div class="text-justify">
                                {!! CustomPages::getcontent("courseOfferedWidgetOneTextTwo") !!}
                            </div>
                        </div>
                    </div><!--end row-->


            </div>
        </div>

        <div class="padding-tb45 bg-color2">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 col-md-offset-2">
                        <div class="text-align-center">
                            <h3 class="margin-0">{!! CustomPages::getcontent("courseOfferedWidgetTwoTitle") !!}</h3>
                            <hr class="sm">
                            {!! CustomPages::getcontent("courseOfferedWidgetTwoDescription") !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="arrow-upwards"><i class="fa fa-angle-down"></i></div>

        <div class="container">
            <div class="accordion" id="toggleArea">
                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseOne"> {!! CustomPages::getcontent("courseTitle1") == "" ? "Title" : CustomPages::getcontent("courseTitle1") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseOne" class="accordion-body collapse">
                        <div class="accordion-inner">
                            {!! CustomPages::getcontent("courseText1") !!}
                        </div>
                    </div>
                </div>

                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseTwo"> {!! CustomPages::getcontent("courseTitle2") == "" ? "Title" : CustomPages::getcontent("courseTitle2") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseTwo" class="accordion-body collapse">
                        <div class="accordion-inner">
                            {!! CustomPages::getcontent("courseText2") !!}
                        </div>
                    </div>
                </div>

                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseThree"> {!! CustomPages::getcontent("courseTitle3") == "" ? "Title" : CustomPages::getcontent("courseTitle3") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseThree" class="accordion-body collapse">
                        <div class="accordion-inner">
                            {!! CustomPages::getcontent("courseText3") !!}
                        </div>
                    </div>
                </div>

                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseFour"> {!! CustomPages::getcontent("courseTitle4") == "" ? "Title" : CustomPages::getcontent("courseTitle4") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseFour" class="accordion-body collapse">
                        <div class="accordion-inner">
                           {!! CustomPages::getcontent("courseText4") !!}
                        </div>
                    </div>
                </div>

                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseFive"> {!! CustomPages::getcontent("courseTitle5") == "" ? "Title" : CustomPages::getcontent("courseTitle5") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseFive" class="accordion-body collapse">
                        <div class="accordion-inner">
                            {!! CustomPages::getcontent("courseText5") !!}
                        </div>
                    </div>
                </div>

                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseSix"> {!! CustomPages::getcontent("courseTitle6") == "" ? "Title" : CustomPages::getcontent("courseTitle6") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseSix" class="accordion-body collapse">
                        <div class="accordion-inner">
                            {!! CustomPages::getcontent("courseText6") !!}
                        </div>
                    </div>
                </div>

                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseSeven"> {!! CustomPages::getcontent("courseTitle7") == "" ? "Title" : CustomPages::getcontent("courseTitle7") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseSeven" class="accordion-body collapse">
                        <div class="accordion-inner">
                            {!! CustomPages::getcontent("courseText7") !!}
                        </div>
                    </div>
                </div>

                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseEight"> {!! CustomPages::getcontent("courseTitle8") == "" ? "Title" : CustomPages::getcontent("courseTitle8") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseEight" class="accordion-body collapse">
                        <div class="accordion-inner">
                            {!! CustomPages::getcontent("courseText8") !!}
                        </div>
                    </div>
                </div>

                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseNine"> {!! CustomPages::getcontent("courseTitle9") == "" ? "Title" : CustomPages::getcontent("courseTitle9") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseNine" class="accordion-body collapse">
                        <div class="accordion-inner">
                            {!! CustomPages::getcontent("courseText9") !!}
                        </div>
                    </div>
                </div>

                <div class="accordion-group panel">
                    <div class="accordion-heading togglize"> <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapseTen"> {!! CustomPages::getcontent("courseTitle10") == "" ? "Title" : CustomPages::getcontent("courseTitle10") !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> </div>
                    <div id="collapseTen" class="accordion-body collapse">
                        <div class="accordion-inner">
                            {!! CustomPages::getcontent("courseText10") !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
@stop