<?php 
    use App\Models\CustomPages; 
    use App\Models\Option; 
?>
@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>{!! CustomPages::getcontent("courseEligibilityPageTitle") !!}</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li><a href="{!! URL::to('course-offered') !!}">Course Offered</a></li>
                    <li>{!! CustomPages::getcontent("courseEligibilityPageTitle") !!}</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="col-md-2 col-sm-12 parallax">
                    @include('frontend/course-sidebar')
                </div>

                <div class="col-md-10">
                    <div class="text-justify">
                        {!! CustomPages::getcontent("courseEligibilityWidgetOneText") !!}
                    </div>

                    <hr class="fw">
                    <div class="row counters">
                        <div class="col-lg-5 col-md-5">
                            <div class="fact-ico"><img src="{!! URL::asset('frontend/images/icons/duration.png') !!}"></div>
                            <div class="timer">{!! CustomPages::getcontent("courseEligibilityDuration") !!}</div>
                            <span class="fact">Course Duration</span>
                        </div>
                        <div class="col-lg-7 col-md-7">
                            <div class="fact-ico"><img src="{!! URL::asset('frontend/images/icons/timing.png') !!}"></div>
                            <div class="timer">{!! CustomPages::getcontent("courseEligibilityTiming") !!}</div>
                            <span class="fact">Timing</span>
                        </div>
                    </div>

                    <hr class="fw">

                    <div class="row counters">
                        <div class="col-lg-5 col-md-5">
                            <div class="fact-ico"><img src="{!! URL::asset('frontend/images/icons/session.png') !!}"></div>
                            <div class="timer">{!! CustomPages::getcontent("courseEligibilitySessionFrequency") !!}</div>
                            <span class="fact">Session Frequency</span>
                        </div>
                        <div class="col-lg-7 col-md-7">
                            <div class="fact-ico"><img src="{!! URL::asset('frontend/images/icons/eligibility.png') !!}"></div>
                            <div class="timer">{!! CustomPages::getcontent("courseEligibilityEligibility") !!}</div>
                            <span class="fact">Eligibility</span>
                        </div>
                    </div>
                    <hr class="fw">

                    <h5 class="subhead">{!! CustomPages::getcontent("courseEligibilityWidgetThreeSubTitle") !!}</h5>
                    <h3 class="accent-color">{!! CustomPages::getcontent("courseEligibilityWidgetThreeTitle") !!}</h3>
                    {!! CustomPages::getcontent("courseEligibilityWidgetThreeText") !!}
                </div>
            </div>
        </div>
    </div>
@stop