<?php

    use App\Models\EventCategories;

    use App\Models\Events;

    use App\Models\Upload;

    use App\Models\GalleryCategories;

    use App\Models\Gallery;

    use App\Models\Option;

     use App\Models\Customfieldmeta;

?>

@extends('frontend/master')

@section('metadetails')

    <meta property="og:url"           content="{!! Request::url() !!}" />

    <meta property="og:type"          content="article" />

    <meta property="og:title"         content="{!! $event->eventTitle !!} - Advertising Club Madras" />

    <meta property="og:description"   content="{!! $event->eventVenue !!}" />

    <meta property="og:image"         content="{!! $event->eventPoster !!}" />



    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:site" content="@AdvertisingClubMadras">

    <meta name="twitter:title" content="{!! $event->eventTitle !!} - Advertising Club Madras">

    <meta name="twitter:description" content="{!! $event->eventVenue !!}">

    <meta name="twitter:creator" content="@AdvertisingClubMadras">

    <meta name="twitter:image" content="{!! $event->eventPoster !!}">

@stop

@section('styles')

    {!! HTML::style('backend/assets/css/jquery-ui.css') !!}

    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.6.3/jquery-ui-timepicker-addon.min.css">

    {!! HTML::style('frontend/css/jquery.lightbox.css') !!}

@stop



@section('content')

    <div class="hero-area">

        <div class="page-header bg-color1 text-center">

            <div class="container">

                <h1>Events</h1>

                <ol class="breadcrumb">

                    <li><a href="{!! URL::to('') !!}">Home</a></li>

                    <li>Events</li>

                </ol>

            </div>

        </div>

    </div>



    <div id="main-container">

        <div class="content padding-b40">

            <div class="container">

                <div class="row">

                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned hidden-xs">

                        <div class="widget sidebar-widget custom_menu">

                            <ul class="pages-sub-menu">

                                <li><a href="{!! URL::to('events/') !!}">All Events</a></li>

                                <?php

                                    $categories = EventCategories::where("status", "active")->get();

                                ?>

                                @foreach($categories as $category)

                                    <?php $link = $category->categorySlug?>

                                    <li  @if($event->eventCategoryID == $category->id) {!! "class='active'"; !!} @endif><a href="{!! URL::to('events/'.$link) !!}">{!! ucwords($category->categoryName) !!}</a></li>

                                @endforeach

                            </ul>

                        </div>

                    </div>

                    <div class="col-md-9 col-xs-12">

                        <div class="single-event">

                            <div class="row">

                                @if(Session::has('errorMessage'))

                                    <div class="alert alert-danger">{!! Session::get('errorMessage') !!}</div>

                                @endif

                                <div class="col-lg-4 col-md-5 col-sm-5">

                                    <div class="hidden-md hidden-lg"><div class="single-event-right"><h2>{!! ucwords($event->eventTitle) !!}</h2></div></div>

                                    <div class="single-event-left dgray-bg">

                                        <a href="{!! $event->eventPoster !!}" title="{!! ucwords($event->eventTitle) !!}" target="_blank"><img src="{!! $event->eventPoster !!}" class="img-icon" alt="{!! ucwords($event->eventTitle) !!}"></a>

                                        

                                        @if($event->gallery != '' && $event->gallery > 0)

                                            <?php

                                                $categorySlug = '';

                                                $gallerySlug = '';

                                                $check = Gallery::find($event->gallery);

                                                if($check){

                                                    $gallerySlug = $check->gallerySlug;



                                                    $checkCat = GalleryCategories::find($check->galleryCategoryID);

                                                    if($checkCat){

                                                        $categorySlug = $checkCat->categorySlug;

                                                    }

                                                }

                                                $link = '';

                                                if($categorySlug != '' && $gallerySlug != ''){

                                                    $link = $categorySlug."/".$gallerySlug;

                                                }

                                            ?>

                                            <div class="spacer-30"></div>

                                            <a href="{!! URL::to('gallery/'.$link) !!}" class="btn btn-default btn-ghost btn-light btn-block">View Gallery</a>

                                        @endif

                                    </div>

                                </div>

                                <div class="col-lg-8 col-md-7 col-sm-7">

                                    <div class="single-event-right">

                                        <div class="hidden-xs"><h2>{!! ucwords($event->eventTitle) !!}</h2></div>

                                        <div class="alert alert-primary">

                                            <p><b>Date:</b><br>{!! date("F d, Y", strtotime($event->eventDate)) !!}</p>

                                            <p><b>Time:</b><br>{!! gmdate("h:i A", $event->eventTime) !!} @if($event->eventEndTime != '') - {!! gmdate("h:i A", $event->eventEndTime) !!} @endif</p>

                                            

                                            @if($event->reportingTime)

                                                <p><b>Reporting Time:</b><br>{!! gmdate("h:i A", $event->reportingTime) !!}</p>

                                            @endif



                                            @if($event->memberFeeText)

                                                <p><b>Entry Fee:</b><br>{!! $event->memberFeeText !!}</p>

                                            @endif


                                            @if($event->eventVenue)
                                                <p><b>Venue:</b><br>{!! $event->eventVenue !!}</p>
                                            @endif

                                            @if($event->eventInformation)
                                                <p><b>Information:</b><br>{!! $event->eventInformation !!}</p>
                                            @endif



                                            @if($event->streaming_link)

                                                <p><b>Registration or Streaming Link:</b><br><a href="{{ $event->streaming_link }}" target="_blank">Click to View/Register</a></p>

                                            @endif



                                            @foreach($custom_info as $info)

                                                @if($info->field_type == 'single_file_upload' || $info->field_type == 'multiple_file_upload')

                                                    <p><b>{!! $info->label_name !!}:</b>

                                                        <a href="{!! asset($info->field_value) !!}" target="_blank"><i class="fa fa-file"></i></a>

                                                    </p>

                                                @else

                                                    <p><b>{!! $info->label_name !!}:</b><br>{!! $info->field_value !!}</p>

                                                @endif

                                            @endforeach

                                        </div>

                                        @if($event->entryType == 'paid')

                                            <form id="registerAndPaymentForm" enctype="multipart/form-data" method="post">

                                                <input type="hidden" name="hiddenId" id="hiddenId" value="{{encrypt($event->id)}}">

                                                <?php $gst = Option::getvalue('GST'); ?>

                                                @if($event->isSportEvent == 'no')

                                                    <div class="row">

                                                        <div class="col-md-6">

                                                        <label>Entry Tickets</label>

                                                        <select name="tickets" id="tickets" class="form-control">

                                                            <option value="1" selected="selected">1</option>

                                                            <option value="2">2</option>

                                                            <option value="3">3</option>

                                                            <option value="4">4</option>

                                                            <option value="5">5</option>

                                                            <option value="6">6</option>

                                                            <option value="7">7</option>

                                                            <option value="8">8</option>

                                                            <option value="9">9</option>

                                                            <option value="10">10</option>

                                                        </select>

                                                        </div>

                                                    </div>

                                                @else

                                                    <input type="hidden" name="tickets" value="1" id="tickets">

                                                @endif



                                                <div class="form-group">

                                                    <label>Are you a Adclubmadras Regsitered Member?&nbsp;&nbsp; </label>

                                                    <input type="radio" class="" name="userType" value="yes">&nbsp;Yes

                                                    <input type="radio" class="" name="userType" value="no" checked="checked">&nbsp;No

                                                </div>

                                                

                                                @foreach($custom_fields_reg as $fields)

                                                    <div class="form-group">

                                                    <label>{{$fields->label_name}} @if($fields->is_required == 'yes') <span class='text-danger'>*</span> @endif</label>

                                                    @if($fields->field_type == 'plain_text' || $fields->field_type == 'datepicker' || $fields->field_type == 'dateandtime' || $fields->field_type == 'phonenumber' || $fields->field_type == 'numbers' || $fields->field_type == 'amount' || $fields->field_type == 'email')

                                                        <input type="text" class="form-control @if($fields->field_type == 'datepicker') R_custom_fields_date @endif @if($fields->field_type == 'dateandtime') R_custom_fields_datetime @endif" id="{{$fields->field_slug}}" name="{{$fields->field_slug}}" value="{{$fields->field_value}}">

                                                    @endif



                                                    @if($fields->field_type == 'text_area')

                                                            <textarea class="form-control" id="{{$fields->field_slug}}" name="{{$fields->field_slug}}"></textarea>

                                                    @endif



                                                    @if($fields->field_type == 'checkbox' || $fields->field_type == 'radio')

                                                            <?php

                                                                $metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();

                                                            ?>

                                                            @foreach($metadata as $m)

                                                                {{$m->field_value}}<input type="{{$fields->field_type}}" id="{{$fields->field_slug}}" name="{{$fields->field_slug}}[]">

                                                            @endforeach

                                                    @endif



                                                    @if($fields->field_type == 'dropdown')

                                                        <?php

                                                            $metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();

                                                        ?>

                                                            <select class="form-control" id="{{$fields->field_slug}}" name="{{$fields->field_slug}}">

                                                                <option value="">Select</option>

                                                                @foreach($metadata as $m)

                                                                    <option value="{{$m->field_value}}">{{$m->field_value}}</option>

                                                                @endforeach

                                                            </select>

                                                    @endif



                                                    @if($fields->field_type == 'single_file_upload')

                                                        <input type="file" class="form-control" name="{{$fields->field_slug}}" id="{{$fields->field_slug}}">

                                                        @if($fields->field_value != '')

                                                            <div class="form-group">

                                                                <a href="{{asset($fields->field_value)}}" target="_blank" style="color: green;">{{$fields->extra_field}} <i class="fa fa-file"></i></a>

                                                                <a href="javascript:;" class="removeCustomFieldFile" data-field="single" data-id="{{encrypt($fields->id)}}" style="color: red;"><i class="fa fa-trash"></i></a>

                                                                <label>Preview</label>

                                                            </div>

                                                        @endif

                                                    @endif



                                                    @if($fields->field_type == 'multiple_file_upload')

                                                            <input type="file" class="form-control" name="{{$fields->field_slug}}[]" id="{{$fields->field_slug}}" multiple="">

                                                        <?php

                                                            $metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();

                                                        ?>

                                                        @if(count($metadata) != 0)

                                                            <div class="form-group">

                                                                <label>Preview</label>

                                                                <ul>

                                                                    @foreach($metadata as $meta)

                                                                        <li>

                                                                            <a href="{{asset($meta->field_value)}}" target="_blank" style="color: green;">{{$meta->extra_field}} <i class="fa fa-file"></i></a>

                                                                            <a href="javascript:;" class="removeCustomFieldFile" data-field="multiple" data-id="{{encrypt($meta->id)}}" style="color: red;"><i class="fa fa-trash"></i></a>

                                                                        </li>

                                                                    @endforeach

                                                                </ul>

                                                            </div>

                                                        @endif

                                                    @endif

                                                    </div>

                                                @endforeach



                                                @if($event->isSportEvent != 'no')

                                                    @if($event->isSportEvent == 'badminton' || $event->isSportEvent == 'tennis')

                                                        @if($event->typeOfTeam == 'single')

                                                            <div class="form-group ">

                                                                <label>Type of Team *</label>

                                                                {!! Form::select("typeOfTeam",[''=>'Select','single'=> 'Singles'], '',["class"=>"form-control", 'id' => 'typeOfTeam']) !!}

                                                            </div>

                                                            

                                                            <div class="form-group" id="singlePlayerCountBox" style="display: none;">

                                                                <label>Singles *</label>

                                                                <select class="form-control" id="singlePlayerCount" name="singlePlayerCount">

                                                                    <option value="">Select Player</option>

                                                                    @for($i = 0; $i< $event->maxSinglesCount; $i++)

                                                                        <option value="{{$i+1}}">{{$i+1}} Player</option>

                                                                    @endfor

                                                                </select>

                                                            </div>



                                                            <div id="SinglePlayerDetail" style="display: none;">

                                                                <p>Singles Player Details</p>

                                                                <hr>

                                                                @for($i = 0; $i< $event->maxSinglesCount; $i++)

                                                                    <div class="form-group singleplayerbox" id="singleplayerbox_{{$i+1}}">

                                                                        <label>Player {{$i+1}} *</label>

                                                                        <input class="form-control" type="text" name="singleplayer_{{$i+1}}" id="singleplayer_{{$i+1}}">

                                                                    </div>

                                                                @endfor

                                                            </div>



                                                        @endif

                                                        @if($event->typeOfTeam == 'double')

                                                            <div class="form-group ">

                                                                <label>Type of Team *</label>

                                                                {!! Form::select("typeOfTeam",[''=>'Select','double' => 'Dobles'], '',["class"=>"form-control", 'id' => 'typeOfTeam']) !!}

                                                            </div>



                                                            <div class="form-group" id="doublePlayerCountBox" style="display: none;">

                                                                <label>Doubles *</label>

                                                                <select class="form-control" id="doublePlayerCount" name="doublePlayerCount">

                                                                    <option value="">Select Team</option>

                                                                    @for($i = 0; $i< $event->maxDoublesCount; $i++)

                                                                        <option class="form-control" value="{{$i+1}}">{{$i+1}} Team</option>

                                                                    @endfor

                                                                </select>

                                                            </div>



                                                            <div id="DoublePlayerDetail" style="display: none;">

                                                                <p>Doubles Player Details</p>

                                                                <hr>

                                                                @for($i = 0; $i< ($event->maxDoublesCount*2); $i++)

                                                                    <div class="form-group doubleplayerbox" id="doubleplayerbox_{{$i+1}}">

                                                                        <label>Player {{$i+1}} *</label>

                                                                        <input class="form-control" type="text" name="doubleplayer_{{$i+1}}" id="doubleplayer_{{$i+1}}">

                                                                    </div>

                                                                @endfor

                                                            </div>



                                                        @endif

                                                        @if($event->typeOfTeam == 'both')

                                                            <div class="form-group ">

                                                                <label>Type of Team *</label>

                                                                {!! Form::select("typeOfTeam",[''=>'Select','single'=> 'Singles','double' => 'Dobles', 'both' => 'Singles and Doubles'], '',["class"=>"form-control", 'id' => 'typeOfTeam']) !!}

                                                            </div>



                                                            <div class="form-group" id="singlePlayerCountBox" style="display: none;">

                                                                <label>Singles *</label>

                                                                <select class="form-control" id="singlePlayerCount" name="singlePlayerCount">

                                                                    <option value="">Select Player</option>

                                                                    @for($i = 0; $i< $event->maxSinglesCount; $i++)

                                                                        <option value="{{$i+1}}">{{$i+1}} Player</option>

                                                                    @endfor

                                                                </select>

                                                            </div>





                                                            <div class="form-group" id="doublePlayerCountBox" style="display: none;">

                                                                <label>Dobules *</label>

                                                                <select class="form-control" id="doublePlayerCount" name="doublePlayerCount">

                                                                    <option value="">Select Team</option>

                                                                    @for($i = 0; $i< $event->maxDoublesCount; $i++)

                                                                        <option value="{{$i+1}}">{{$i+1}} Team</option>

                                                                    @endfor

                                                                </select>

                                                            </div>



                                                            <div id="SinglePlayerDetail" style="display: none;">

                                                                <p>Singles Player Details</p>

                                                                <hr>

                                                                 @for($i = 0; $i< $event->maxSinglesCount; $i++)

                                                                    <div class="form-group singleplayerbox" id="singleplayerbox_{{$i+1}}">

                                                                        <label>Player {{$i+1}} *</label>

                                                                        <input class="form-control" type="text" name="singleplayer_{{$i+1}}" id="singleplayer_{{$i+1}}">

                                                                    </div>

                                                                @endfor

                                                            </div>



                                                            <div id="DoublePlayerDetail" style="display: none;">

                                                                <p>Doubles Player Details</p>

                                                                <hr>

                                                                 @for($i = 0; $i< ($event->maxDoublesCount*2); $i++)

                                                                    <div class="form-group doubleplayerbox" id="doubleplayerbox_{{$i+1}}">

                                                                        <label>Player {{$i+1}} *</label>

                                                                        <input class="form-control" type="text" name="doubleplayer_{{$i+1}}" id="doubleplayer_{{$i+1}}">

                                                                    </div>

                                                                @endfor

                                                            </div>



                                                        @endif



                                                    @endif

                                                    @if($event->isSportEvent == 'cricket')

                                                        <p>Player Details</p>

                                                        <hr>

                                                        @for($i = 0; $i< $event->maximumPlayer; $i++)

                                                            <div class="form-group ">

                                                                <label>Player {{$i+1}} *</label>

                                                                <input class="form-control" type="text" name="cplayer_{{$i+1}}" id="cplayer_{{$i+1}}">

                                                            </div>

                                                        @endfor

                                                    @endif

                                                @endif

                                                <button type="submit" id="eventRegisterBtn" class="btn btn-default">Register & Payment</button>

                                            </form>

                                        @endif

                                        

                                        <div class="spacer-30"></div>


                                        @if($event->eventDescription)
                                            <div><b>Terms & Conditions:</b></div>

                                            {!! $event->eventDescription !!}
                                         @endif



                                        <div class="spacer-30"></div>

                                        

                                        <ul class="social-icons social-icons-colored social-icons-inverted">

                                            <li class="meta-data">SHARE EVENT</li>

                                            <li class="facebook"><a href="https://www.facebook.com/sharer/sharer.php?u={!! Request::url() !!}" title="Facebook"  class="social-button "><i class="fa fa-facebook"></i></a>

                                            </li>

                                            <li class="twitter"><a href="https://twitter.com/intent/tweet?text={!! $event->eventTitle !!}&amp;url={!! Request::url() !!}" title="Twitter" class="social-button " id=""><i class="fa fa-twitter"></i></a></li>

                                        </ul>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <div id="hiddenForm" style="display: none;"></div>

@stop



@section('script')

   {!! HTML::script('backend/assets/js/jquery-ui.js') !!}

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.6.3/jquery-ui-timepicker-addon.min.js"></script>

    {!! HTML::script('frontend/js/share.js') !!}

    {!! HTML::script('frontend/js/jquery.lightbox-0.5.min.js') !!}

    <script type="text/javascript">

        $(function() {

            $('#event-poster a').lightBox();

        });



        $(document).on('click', '.eventRegister', function () {

            @if(Auth::guest())

                swal({

                    title: "Login!",

                    text: "Please login to continue.",

                    icon: "warning",

                    buttons: ["Cancel", "Login"],

                    dangerMode: true,

                })

                .then((willDelete) => {

                    if (willDelete) {

                        <?php

                            Session::put('redirectUrl', Request::path());

                        ?>

                        window.location = '/login';

                    }

                });

                return false;

            @endif

        });



        $(".R_custom_fields_date").datepicker({

            dateFormat:'yy-mm-dd',

        });

        $(".R_custom_fields_datetime").datetimepicker({

            dateFormat:'yy-mm-dd', 

            timeFormat: 'h:mm',

        });



        $('#typeOfTeam').on('change', function(){

            var t = $(this).val();

            $('#singlePlayerCount').val('');

            $('#doublePlayerCount').val('');

            $('#singlePlayerCountBox').hide();

            $('#SinglePlayerDetail').hide();

            $('.singleplayerbox').hide();



            $('#doublePlayerCountBox').hide();

            $('#DoublePlayerDetail').hide();

            $('.doubleplayerbox').hide();



            if(t == 'single' || t == 'both'){

                $('#singlePlayerCountBox').show();

            }



            if(t == 'double' || t == 'both'){

                $('#doublePlayerCountBox').show();

            }

        });



        $('#singlePlayerCount').on('change', function(){

            var c = $(this).val();

            $('.singleplayerbox').hide();

            $('#SinglePlayerDetail').hide();

            if(c == '' || c == undefined ){

                return false;

            }

            for(i=1; i<=c; i++){

                $('#singleplayerbox_'+i).show();

            }

            $('#SinglePlayerDetail').show();

        });



        $('#doublePlayerCount').on('change', function(){

            var c = $(this).val();

            $('.doubleplayerbox').hide();

            $('#DoublePlayerDetail').hide();

            if(c == '' || c == undefined ){

                return false;

            }

            for(i=1; i<=(c*2); i++){

                $('#doubleplayerbox_'+i).show();

            }

            $('#DoublePlayerDetail').show();

        });



        $('#registerAndPaymentForm').submit(function(e) {

            e.preventDefault();

            var t = $('#eventRegisterBtn'); $('.validate').remove(); $('.smsg').remove();

            var txt = t.text();

            var hiddenId = $('#hiddenId').val();

            var tickets = $('#tickets').val(); $('.validate').remove();

            let formData = new FormData(this);

                @if(Auth::guest())

                    swal({

                        title: "Login!",

                        text: "Please login to continue.",

                        icon: "warning",

                        buttons: ["Cancel", "Login"],

                        dangerMode: true,

                    })

                    .then((willDelete) => {

                        if (willDelete) {

                            <?php

                                Session::put('redirectUrl', Request::path());

                            ?>

                            window.location = '/login';

                        }

                    });

                    return false;

                @endif

            t.text('Procssing...').prop( "disabled", true );

            $.ajax({

                contentType: false,

                processData: false,

                type: "POST",

                url:  "{{route('event.registration')}}",

                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

                data: formData,

                dataType: "json",

                success: function(data){

                    t.text(txt).prop( "disabled", false );

                    if(data.status == "success"){

                        $('#hiddenForm').html(data.template);

                        $('#hiddenFormBox').submit();

                    }else if(data.status == "validation"){

                        $.each(data.validation, function(k,v){

                            k = k.split('.')[0];

                            $('#'+k).after('<span class="validate" style="color:red;">'+v+'</span>');

                        });

                    }else{

                         t.text(txt).prop( "disabled", false );

                         alert(data.msg);

                    }

                    return false;

                },

                error: function(e){

                    t.text(txt).prop( "disabled", false );

                    alert('Error. Please try again');

                    return false;

                }

            });/* end of ajax */



        });



    </script>

@stop