<?php
    use App\Models\EventCategories;
    use App\Models\Events;
    use App\Models\Upload;
?>
@extends('frontend/master')

@section('styles')
    <style type="text/css">
        .grid-item-inner {
            min-height: 45px;
        }
        .event-grid-time {
            background-color: rgba(5, 60, 90,0.8);
            padding: 5px 10px;
            top: -35px;
        }
        .grid-item h4 {
            text-overflow: ellipsis;
            white-space: nowrap;
            overflow: hidden;
        }
        .grid-item-inner p {
            font-size: 14px;
            margin-bottom: 0
        }
    </style>
@stop

@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Events</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li>Events</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned hidden-xs">
                        <div class="widget sidebar-widget custom_menu">
                            <ul class="pages-sub-menu">
                                <li class='active'><a href="{!! URL::to('events/') !!}">All Events</a></li>
                                <?php
                                    $categories = EventCategories::where("status", "active")->get();
                                ?>
                                @foreach($categories as $category)
                                    <?php $link = $category->categorySlug?>
                                    <li><a href="{!! URL::to('events/'.$link) !!}">{!! ucwords($category->categoryName) !!}</a></li>
                                @endforeach
                            </ul>
                        </div>
                    </div>

                    <div class="col-md-9 col-xs-12">
                        <?php
                            $events = Events::where("status", "active")->orderBy("eventDate", "DESC")->get();
                        ?>

                        <h5 class="subhead">{!! count($events) !!} Events</h5>
                        <h3 class="accent-color">All Events</h3>
                        <ul class="events-list events-list-compact">
                            @foreach($events as $event)
                                    <?php
                                        $categorySlug = EventCategories::geteventcategoryslug($event->eventCategoryID);
                                        $link = 'events';
                                        if($categorySlug != ''){
                                            $link = $categorySlug."/".$event->eventSlug;
                                        }
                                        
                                        $feature = "http://placehold.it/600x400";
                                        $check = Upload::where("productid", $event->id)->where("type", "feature")->first();
                                        if($check){
                                            $feature = $check->path;
                                        }
                                    ?>
                                <li>
                                    <div class="event-date">
                                        <div class="event-month">{!! date("M'y", strtotime($event->eventDate)) !!}</div>
                                        <div class="event-day">{!! date("d", strtotime($event->eventDate)) !!}</div>
                                    </div>
                                    <a href="{!! URL::to('events/'.$link) !!}" class="btn btn-default btn-sm">Event Details</a>
                                    <a href="{!! URL::to('events/'.$link) !!}"><strong>{!! ucwords($event->eventTitle) !!}</strong></a>
                                    <span class="meta-data">{!! date("l", strtotime($event->eventDate)) !!}, {!! gmdate("h:i A", $event->eventTime) !!}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop