<?php
    use App\Models\ExecutiveCommitteeMembers;
?>
@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Executive Comittee Members</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li><a href="{!! URL::to('about') !!}">About Us</a></li>
                    <li>Executive Comittee Members</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="col-md-2 col-sm-12">
                    @include('frontend/about-sidebar')
                </div>

                <div class="col-md-10">
                    <?php
                        $executiveComitteeMembers = ExecutiveCommitteeMembers::where("status", "active")->orderBy('id', 'DESC')->get();
                        $i = 1;
                    ?>

                    <div class="accordion" id="toggleArea">
                        @foreach($executiveComitteeMembers as $executiveComitteeMember)
                            <div class="accordion-group panel">
                                <div class="accordion-heading togglize"> 
                                    <a class="accordion-toggle" data-toggle="collapse" data-parent="#" href="#collapse{!! $i !!}"> {!! $executiveComitteeMember->yearTitle !!} <i class="fa fa-plus-circle"></i> <i class="fa fa-minus-circle"></i> </a> 
                                </div>

                                <div id="collapse{!! $i !!}" class="accordion-body collapse">
                                    <div class="accordion-inner">
                                        {!! $executiveComitteeMember->membersDescription !!}
                                    </div>
                                </div>
                            </div>
                            <?php $i++; ?>
                        @endforeach
                    </div>
                    <!-- End Toggle --> 
                </div>
            </div>
        </div>
    </div>
@stop