<?php
    use App\Models\Faculties;
?>
@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Faculty</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li><a href="{!! URL::to('course-offered') !!}">Course Offered</a></li>
                    <li>Faculty</li>
                </ol>
            </div>
        </div>
    </div>

    <?php
        $faculties = Faculties::where("status", "active")->get();
    ?>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="col-md-2 col-sm-12 parallax">
                    @include('frontend/course-sidebar')
                </div>

                <div class="col-md-10">
                    <ul class="team-list row">
                        @foreach($faculties as $faculty)
                            <li class="team-list-item col-md-12">
                                <img src="{!! $faculty->facultyImage != "" ? $faculty->facultyImage : 'http://placehold.it/400x400&amp;text=IMAGE+PLACEHOLDER' !!}" alt="">
                                <h5>{!! $faculty->facultyName !!}</h5>
                                <span class="meta-data">{!! $faculty->facultyDesignatione !!}</span>
                                <span class="meta-desc">{!! $faculty->description !!}</span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
@stop