<?php
    use App\Models\GalleryCategories;
    use App\Models\Gallery;
    use App\Models\Upload;
?>
@extends('frontend/master')

@section('styles')
    {!! HTML::style('frontend/css/jquery.lightbox.css') !!}
    <style type="text/css">
        .grid-item-inner {
            min-height: auto;
            margin-bottom: 25px;
        }
    </style>
@stop

@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Gallery</h1>
                <ol class="breadcrumb">
                    <li><a href="{!!URL::to('')!!}">Home</a></li>
                    <li>Gallery</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned">
                        <div class="widget sidebar-widget custom_menu">
                            <ul class="pages-sub-menu">
                                <li><a href="{!! URL::to('gallery') !!}">All Gallery</a></li>
                                <?php
                                    $categories = GalleryCategories::where("status", "active")->get();
                                ?>
                                @foreach($categories as $category)
                                    <?php $link = $category->categorySlug ?>
                                    <li @if($category->id == $album->galleryCategoryID) {!! "class='active'" !!} @endif><a href="{!! URL::to('gallery/'.$link) !!}">{!! ucwords($category->categoryName) !!}</a></li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <h5 class="subhead">{!! $totalCount !!} Photos</h5>
                        <h3 class="accent-color">{!! $album->galleryTitle !!}</h3>
                        

                        @if($album->description != "")
                            <div class="grid-item-inner">
                                <h4 class="margin-0">{!! $album->descriptionTitle !!}</h4>
                                <div>
                                    {!! $album->description !!}
                                </div>
                            </div>
                        @endif
                        

                        <div class="row" id="thumbnails">
                            @foreach($photos as $photo)
                                <div class="col-md-3 col-sm-3 col-xs-6">
                                    <a href="{!! $photo->path !!}"><img src="{!! $photo->path !!}" class="img-icon" alt="turntable"></a>
                                </div>
                            @endforeach
                        </div>
                        {{ $photos->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop


@section('script')
    {!! HTML::script('frontend/js/jquery.lightbox-0.5.min.js') !!}
    <script type="text/javascript">
        $(function() {
            $('#thumbnails a').lightBox();
        });
    </script>
@stop