<?php
    use App\Models\GalleryCategories;
    use App\Models\Gallery;
    use App\Models\Upload;
?>
@extends('frontend/master')

@section('styles')
    <style type="text/css">
        .grid-item-inner {
            min-height: 145px;
        }
        .event-grid-time {
            background-color: rgba(5, 60, 90,0.8);
            padding: 5px 10px;
            top: -35px;
        }
        .grid-item-inner p {
            font-size: 13px;
            margin-bottom: 0
        }
    </style>
@stop

@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Gallery</h1>
                <ol class="breadcrumb">
                    <li><a href="{!!URL::to('')!!}">Home</a></li>
                    <li>Gallery</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned">
                        <div class="widget sidebar-widget custom_menu">
                            <ul class="pages-sub-menu">
                                <li><a href="{!! URL::to('gallery') !!}">All Gallery</a></li>
                                <?php
                                    $categories = GalleryCategories::where("status", "active")->get();
                                ?>
                                @foreach($categories as $category)
                                    <?php $link = $category->categorySlug ?>
                                    <li @if($id == $category->id) {!! "class='active'" !!} @endif><a href="{!! URL::to('gallery/'.$link) !!}">{!! ucwords($category->categoryName) !!}</a></li>
                                @endforeach
                            </ul>
                        </div>
                    </div>

                    <div class="col-md-9">
                        <?php
                            //$firstCategory = GalleryCategories::where("status", "active")->first();
                            //$albums = Gallery::where("status", "active")->where("galleryCategoryID", $firstCategory->id)->get();
                        ?>
                        <h5 class="subhead">{!! count($albums) !!} Albums</h5>
                        <h3 class="accent-color">{!! ucwords($album->categoryName) !!}</h3>
                        <div class="row">
                            <ul class="list-style">
                                @foreach($albums as $album)
                                    <?php
                                        $catgegorySlug = '';
                                        $check = GalleryCategories::find($album->galleryCategoryID);
                                        if($check){
                                            $categorySlug = $check->categorySlug;
                                        }
                                        $link = '';
                                        if($categorySlug != ''){
                                            $link = $categorySlug."/".$album->gallerySlug;
                                        }
                                        $feature = "http://placehold.it/600x400";
                                        $check = Upload::where("productid", $album->id)->where("type", "feature")->first();
                                        if($check){
                                            $feature = $check->path;
                                        }
                                    ?>
                                    <li class="grid-item event-grid-item col-md-4 col-sm-4 format-standard">
                                        <a href="{!! URL::to('gallery/'.$link) !!}" class="media-box">
                                            <img src="{!! $feature !!}" alt="{!! ucwords($album->galleryTitle ) !!}">
                                        </a>

                                        <div class="grid-item-inner">
                                            <span class="event-grid-time">{!! date("F d, Y", strtotime($album->galleryDate)) !!}</span>
                                            <h4 class="margin-5"><a href="{!! URL::to('gallery/'.$link) !!}" title="{!! ucwords($album->galleryTitle ) !!}">{!! ucwords($album->galleryTitle ) !!}</a></h4>
                                            <p><b>{!! $album->galleryHostedBy !!}</b><br>
                                            <div class="text_overflow">{!! $album->hostDesignation !!}</div>
                                            <div class="text_overflow">{!! $album->hostCompanyName !!}</div></p>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop